/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public final class TableHelper {
    private TableHelper() {
    }

    public static PropertyChangeListener addModelTracker(JTable table, final TableModelListener listener) {
        PropertyChangeListener propListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                TableModel oldModel = (TableModel)event.getOldValue();
                TableModel newModel = (TableModel)event.getNewValue();
                if (oldModel != null) {
                    oldModel.removeTableModelListener(listener);
                }
                if (newModel != null) {
                    newModel.addTableModelListener(listener);
                }
            }
        };
        table.addPropertyChangeListener("model", propListener);
        table.getModel().addTableModelListener(listener);
        return propListener;
    }

    public static PropertyChangeListener addColumnModelTracker(JTable table, final TableColumnModelListener listener) {
        PropertyChangeListener propListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                TableColumnModel oldModel = (TableColumnModel)event.getOldValue();
                TableColumnModel newModel = (TableColumnModel)event.getNewValue();
                if (oldModel != null) {
                    oldModel.removeColumnModelListener(listener);
                }
                if (newModel != null) {
                    newModel.addColumnModelListener(listener);
                }
            }
        };
        table.addPropertyChangeListener("columnModel", propListener);
        table.getColumnModel().addColumnModelListener(listener);
        return propListener;
    }

    public static void layoutHeaders(JTable table) {
        int column = 0;
        Enumeration<TableColumn> columns = table.getTableHeader().getColumnModel().getColumns();
        while (columns.hasMoreElements()) {
            TableColumn c = columns.nextElement();
            Component component = c.getHeaderRenderer().getTableCellRendererComponent(table, c.getHeaderValue(), false, false, -1, column);
            c.setPreferredWidth(Math.max(c.getPreferredWidth(), component.getPreferredSize().width));
            ++column;
        }
    }

    public static void layoutColumns(JTable table, boolean onlyVisibleRows) {
        int column = 0;
        int firstRow = onlyVisibleRows ? TableHelper.getFirstVisibleRow(table) : 0;
        int lastRow = onlyVisibleRows ? TableHelper.getLastVisibleRow(table) : table.getModel().getRowCount() - 1;
        Dimension intercellSpacing = table.getIntercellSpacing();
        JTableHeader tableHeader = table.getTableHeader();
        Enumeration<TableColumn> columns = tableHeader.getColumnModel().getColumns();
        while (columns.hasMoreElements()) {
            TableColumn c = columns.nextElement();
            Component component = c.getHeaderRenderer() != null ? c.getHeaderRenderer().getTableCellRendererComponent(table, c.getHeaderValue(), false, false, -1, column) : tableHeader.getDefaultRenderer().getTableCellRendererComponent(table, c.getHeaderValue(), false, false, -1, column);
            int width = Math.max(c.getWidth(), component.getPreferredSize().width);
            if (firstRow >= 0) {
                int d = lastRow;
                for (int i = firstRow; i <= d; ++i) {
                    width = Math.max(width, table.getCellRenderer((int)i, (int)column).getTableCellRendererComponent((JTable)table, (Object)table.getModel().getValueAt((int)i, (int)column), (boolean)false, (boolean)false, (int)i, (int)column).getPreferredSize().width + intercellSpacing.width);
                }
            }
            c.setPreferredWidth(width);
            c.setWidth(width);
            ++column;
        }
    }

    public static JScrollPane findScrollPane(JTable table) {
        return (JScrollPane)SwingUtilities.getAncestorOfClass(JScrollPane.class, table);
    }

    public static int getFirstVisibleRow(JTable table) {
        Point p = table.getVisibleRect().getLocation();
        return table.rowAtPoint(p);
    }

    public static int getLastVisibleRow(JTable table) {
        Point p = table.getVisibleRect().getLocation();
        p.y = p.y + table.getVisibleRect().height - 1;
        int result = table.rowAtPoint(p);
        if (result > 0) {
            return result;
        }
        if (table.getVisibleRect().height > 0) {
            return table.getRowCount() - 1;
        }
        return -1;
    }

    public static void setColumnWidths(JTable table, int[] columnWidths) {
        TableColumnModel columns = table.getTableHeader().getColumnModel();
        if (columnWidths == null || columnWidths.length != columns.getColumnCount()) {
            return;
        }
        int c = columns.getColumnCount();
        for (int i = 0; i < c; ++i) {
            columns.getColumn(i).setPreferredWidth(columnWidths[i]);
        }
        table.getTableHeader().resizeAndRepaint();
        JScrollPane scrollpane = TableHelper.findScrollPane(table);
        if (scrollpane != null) {
            scrollpane.invalidate();
        }
        table.invalidate();
    }

    public static int[] getColumnWidths(JTable table) {
        TableColumnModel model = table.getTableHeader().getColumnModel();
        int[] columnWidths = new int[model.getColumnCount()];
        int c = columnWidths.length;
        for (int i = 0; i < c; ++i) {
            columnWidths[i] = model.getColumn(i).getWidth();
        }
        return columnWidths;
    }
}

