/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.swing;

import com.l2fprod.common.beans.editor.FixedButton;
import javax.swing.JButton;
import javax.swing.JComboBox;

public interface ComponentFactory {
    public JButton createMiniButton();

    public JComboBox createComboBox();

    public static class DefaultComponentFactory
    implements ComponentFactory {
        private DefaultComponentFactory() {
        }

        @Override
        public JButton createMiniButton() {
            return new FixedButton();
        }

        @Override
        public JComboBox createComboBox() {
            return new JComboBox();
        }
    }

    public static class Helper {
        static ComponentFactory factory = new DefaultComponentFactory();

        private Helper() {
        }

        public static ComponentFactory getFactory() {
            return factory;
        }

        public static void setFactory(ComponentFactory factory) {
            Helper.factory = factory;
        }
    }
}

