/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.beans.editor;

import com.l2fprod.common.beans.editor.AbstractPropertyEditor;
import com.l2fprod.common.swing.LookAndFeelTweaks;
import com.l2fprod.common.util.converter.ConverterRegistry;
import com.l2fprod.common.util.converter.NumberConverters;
import java.lang.reflect.InvocationTargetException;
import java.text.NumberFormat;
import javax.swing.JFormattedTextField;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;

public abstract class NumberPropertyEditor
extends AbstractPropertyEditor {
    private final Class<?> type;
    private Object lastGoodValue;

    public NumberPropertyEditor(Class<?> type) {
        if (!Number.class.isAssignableFrom(type)) {
            throw new IllegalArgumentException("type must be a subclass of Number");
        }
        this.editor = new JFormattedTextField();
        this.type = type;
        ((JFormattedTextField)this.editor).setValue(this.getDefaultValue());
        ((JFormattedTextField)this.editor).setBorder(LookAndFeelTweaks.EMPTY_BORDER);
        NumberFormat format = NumberConverters.DEFAULT_FORMAT;
        ((JFormattedTextField)this.editor).setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(format)));
    }

    @Override
    public Object getValue() {
        String text = ((JTextField)this.editor).getText();
        if (text == null || text.trim().length() == 0) {
            return this.getDefaultValue();
        }
        text = text.replace(',', '.');
        StringBuilder number = new StringBuilder();
        number.ensureCapacity(text.length());
        int c = text.length();
        for (int i = 0; i < c; ++i) {
            char character = text.charAt(i);
            if ('.' == character || '-' == character || Double.class.equals(this.type) && 'E' == character || Float.class.equals(this.type) && 'E' == character || Character.isDigit(character)) {
                number.append(character);
                continue;
            }
            if (' ' != character) break;
        }
        try {
            this.lastGoodValue = ConverterRegistry.instance().convert(this.type, number.toString());
        }
        catch (Exception e) {
            UIManager.getLookAndFeel().provideErrorFeedback(this.editor);
        }
        return this.lastGoodValue;
    }

    @Override
    public void setValue(Object value) {
        if (value instanceof Number) {
            ((JFormattedTextField)this.editor).setText(value.toString());
        } else {
            ((JFormattedTextField)this.editor).setValue(this.getDefaultValue());
        }
        this.lastGoodValue = value;
    }

    private Object getDefaultValue() {
        try {
            return this.type.getConstructor(String.class).newInstance("0");
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

