/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.beans.editor;

import com.l2fprod.common.annotations.EditorRegistry;
import com.l2fprod.common.beans.editor.ComboBoxPropertyEditor;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JComboBox;

@EditorRegistry(type={Font.class})
public class FontPropertyEditor
extends ComboBoxPropertyEditor {
    private static final Map<String, Font> FONT_MAP = new TreeMap<String, Font>();

    public FontPropertyEditor() {
        for (Font f : GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts()) {
            if (FONT_MAP.containsKey(f.getName())) continue;
            FONT_MAP.put(f.getName(), f);
        }
        this.setAvailableValues(FONT_MAP.keySet().toArray(new String[0]));
    }

    @Override
    public Object getValue() {
        JComboBox e = (JComboBox)this.editor;
        String f1 = (String)e.getSelectedItem();
        Font f = new Font(f1, 0, 12);
        return f;
    }

    @Override
    public void setValue(Object value) {
        JComboBox e = (JComboBox)this.editor;
        Font f = (Font)value;
        for (int ii = 0; ii < e.getItemCount(); ++ii) {
            if (value == null || !e.getItemAt(ii).equals(f.getName())) continue;
            e.setSelectedIndex(ii);
            break;
        }
    }
}

