/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.beans.editor;

import com.l2fprod.common.annotations.EditorRegistry;
import com.l2fprod.common.beans.editor.AbstractPropertyEditor;
import com.l2fprod.common.swing.LookAndFeelTweaks;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JTextField;

@EditorRegistry(type={Date.class})
public class DateStringPropertyEditor
extends AbstractPropertyEditor {
    public static final SimpleDateFormat DEFAULT_DATE_FORMAT = new SimpleDateFormat("MM-dd-yyy");
    private static final Logger LOGGER = Logger.getLogger(DateStringPropertyEditor.class.getName());

    public DateStringPropertyEditor() {
        this.editor = new JTextField();
        ((JTextField)this.editor).setBorder(LookAndFeelTweaks.EMPTY_BORDER);
    }

    public DateStringPropertyEditor(Locale locale) {
        this();
        ((JTextField)this.editor).setLocale(locale);
    }

    @Override
    public Object getValue() {
        Date d = Calendar.getInstance().getTime();
        try {
            d = DEFAULT_DATE_FORMAT.parse(((JTextField)this.editor).getText());
        }
        catch (ParseException ex) {
            Logger.getLogger(DateStringPropertyEditor.class.getName()).log(Level.SEVERE, null, ex);
        }
        return d;
    }

    @Override
    public void setValue(Object value) {
        if (value != null) {
            Date c = (Date)value;
            ((JTextField)this.editor).setText(DEFAULT_DATE_FORMAT.format(c));
        }
    }

    @Override
    public String getAsText() {
        Date localDate = (Date)this.getValue();
        String s = DEFAULT_DATE_FORMAT.format(localDate);
        LOGGER.log(Level.WARNING, "getAsText(): {0}", s);
        return s;
    }
}

