/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.beans.editor;

import com.l2fprod.common.beans.editor.AbstractPropertyEditor;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class ComboBoxPropertyEditor
extends AbstractPropertyEditor {
    private Object oldValue;
    private Icon[] icons;

    public ComboBoxPropertyEditor() {
        this.editor = new JComboBox(){

            @Override
            public void setSelectedItem(Object anObject) {
                ComboBoxPropertyEditor.this.oldValue = this.getSelectedItem();
                super.setSelectedItem(anObject);
            }
        };
        final JComboBox combo = (JComboBox)this.editor;
        combo.setRenderer(new Renderer());
        combo.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                ComboBoxPropertyEditor.this.firePropertyChange(ComboBoxPropertyEditor.this.oldValue, combo.getSelectedItem());
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }
        });
        combo.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    ComboBoxPropertyEditor.this.firePropertyChange(ComboBoxPropertyEditor.this.oldValue, combo.getSelectedItem());
                }
            }
        });
        combo.setSelectedIndex(-1);
    }

    @Override
    public Object getValue() {
        Object selected = ((JComboBox)this.editor).getSelectedItem();
        if (selected instanceof Value) {
            return ((Value)selected).value;
        }
        return selected;
    }

    @Override
    public void setValue(Object value) {
        JComboBox combo = (JComboBox)this.editor;
        int index = -1;
        int c = combo.getModel().getSize();
        for (int i = 0; i < c; ++i) {
            Object current = combo.getModel().getElementAt(i);
            if (value != current && (current == null || !current.equals(value))) continue;
            index = i;
            break;
        }
        ((JComboBox)this.editor).setSelectedIndex(index);
    }

    public void setAvailableValues(Object[] values) {
        ((JComboBox)this.editor).setModel(new DefaultComboBoxModel<Object>(values));
    }

    public void setAvailableIcons(Icon[] icons) {
        this.icons = icons;
    }

    public static final class Value {
        private Object value;
        private Object visualValue;

        public Value(Object value, Object visualValue) {
            this.value = value;
            this.visualValue = visualValue;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            return this.value == o || this.value != null && this.value.equals(o);
        }

        public int hashCode() {
            return this.value == null ? 0 : this.value.hashCode();
        }
    }

    public class Renderer
    extends DefaultListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component component = super.getListCellRendererComponent((JList<?>)list, value instanceof Value ? ((Value)value).visualValue : value, index, isSelected, cellHasFocus);
            if (ComboBoxPropertyEditor.this.icons != null && index >= 0 && component instanceof JLabel) {
                ((JLabel)component).setIcon(ComboBoxPropertyEditor.this.icons[index]);
            }
            return component;
        }
    }
}

