/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.beans.editor;

import com.l2fprod.common.annotations.EditorRegistry;
import com.l2fprod.common.beans.editor.AbstractPropertyEditor;
import com.l2fprod.common.swing.LookAndFeelTweaks;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JTextField;

@EditorRegistry(type={Calendar.class})
public class CalendarStringPropertyEditor
extends AbstractPropertyEditor {
    public static final SimpleDateFormat DEFAULT_DATE_FORMAT = new SimpleDateFormat("MM-dd-yyy");
    private static final Logger LOGGER = Logger.getLogger(CalendarStringPropertyEditor.class.getName());

    public CalendarStringPropertyEditor() {
        this.editor = new JTextField();
        ((JTextField)this.editor).setBorder(LookAndFeelTweaks.EMPTY_BORDER);
    }

    public CalendarStringPropertyEditor(Locale locale) {
        this();
        ((JTextField)this.editor).setLocale(locale);
    }

    @Override
    public Object getValue() {
        Date d = Calendar.getInstance().getTime();
        try {
            d = DEFAULT_DATE_FORMAT.parse(((JTextField)this.editor).getText());
        }
        catch (ParseException ex) {
            Logger.getLogger(CalendarStringPropertyEditor.class.getName()).log(Level.SEVERE, null, ex);
        }
        Calendar c = Calendar.getInstance();
        c.setTime(d);
        return c;
    }

    @Override
    public void setValue(Object value) {
        if (value != null) {
            Calendar c = (Calendar)value;
            ((JTextField)this.editor).setText(DEFAULT_DATE_FORMAT.format(c.getTime()));
        }
    }

    @Override
    public String getAsText() {
        Calendar localDate = (Calendar)this.getValue();
        String s = DEFAULT_DATE_FORMAT.format(localDate.getTime());
        LOGGER.log(Level.WARNING, "getAsText(): {0}", s);
        return s;
    }
}

