/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.beans;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class BeanUtils {
    private BeanUtils() {
    }

    public static Method getReadMethod(Class<?> clazz, String propertyName) {
        Method readMethod = null;
        try {
            PropertyDescriptor[] thisProps;
            for (PropertyDescriptor pd : thisProps = Introspector.getBeanInfo(clazz).getPropertyDescriptors()) {
                if (!pd.getName().equals(propertyName) || pd.getReadMethod() == null) continue;
                readMethod = pd.getReadMethod();
                break;
            }
        }
        catch (IntrospectionException ex) {
            Logger.getLogger(BeanUtils.class.getName()).log(Level.SEVERE, null, ex);
        }
        return readMethod;
    }

    public static Method getWriteMethod(Class<?> clazz, String propertyName) {
        Method writeMethod = null;
        try {
            PropertyDescriptor[] thisProps;
            for (PropertyDescriptor pd : thisProps = Introspector.getBeanInfo(clazz).getPropertyDescriptors()) {
                if (!pd.getName().equals(propertyName) || pd.getWriteMethod() == null) continue;
                writeMethod = pd.getWriteMethod();
                break;
            }
        }
        catch (IntrospectionException ex) {
            Logger.getLogger(BeanUtils.class.getName()).log(Level.SEVERE, null, ex);
        }
        return writeMethod;
    }
}

