/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.util.converter;

import com.l2fprod.common.util.converter.Converter;
import com.l2fprod.common.util.converter.ConverterRegistry;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.StringTokenizer;
import javax.swing.plaf.DimensionUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.InsetsUIResource;

public class AWTConverters
implements Converter {
    public void register(ConverterRegistry registry) {
        registry.addConverter(Dimension.class, String.class, this);
        registry.addConverter(String.class, Dimension.class, this);
        registry.addConverter(DimensionUIResource.class, String.class, this);
        registry.addConverter(Insets.class, String.class, this);
        registry.addConverter(String.class, Insets.class, this);
        registry.addConverter(InsetsUIResource.class, String.class, this);
        registry.addConverter(Point.class, String.class, this);
        registry.addConverter(String.class, Point.class, this);
        registry.addConverter(Rectangle.class, String.class, this);
        registry.addConverter(String.class, Rectangle.class, this);
        registry.addConverter(Font.class, String.class, this);
        registry.addConverter(FontUIResource.class, String.class, this);
    }

    @Override
    public Object convert(Class type, Object value) {
        if (String.class.equals((Object)type)) {
            if (value instanceof Rectangle) {
                return ((Rectangle)value).getX() + " " + ((Rectangle)value).getY() + " " + ((Rectangle)value).getWidth() + " " + ((Rectangle)value).getHeight();
            }
            if (value instanceof Insets) {
                return ((Insets)value).top + " " + ((Insets)value).left + " " + ((Insets)value).bottom + " " + ((Insets)value).right;
            }
            if (value instanceof Dimension) {
                return ((Dimension)value).getWidth() + " x " + ((Dimension)value).getHeight();
            }
            if (Point.class.equals(value.getClass())) {
                return ((Point)value).getX() + " " + ((Point)value).getY();
            }
            if (value instanceof Font) {
                return ((Font)value).getFontName() + ", " + ((Font)value).getStyle() + ", " + ((Font)value).getSize();
            }
        }
        if (value instanceof String) {
            if (Rectangle.class.equals((Object)type)) {
                double[] values = this.convert((String)value, 4, " ");
                if (values == null) {
                    throw new IllegalArgumentException("Invalid format");
                }
                Rectangle rect = new Rectangle();
                rect.setFrame(values[0], values[1], values[2], values[3]);
                return rect;
            }
            if (Insets.class.equals((Object)type)) {
                double[] values = this.convert((String)value, 4, " ");
                if (values == null) {
                    throw new IllegalArgumentException("Invalid format");
                }
                return new Insets((int)values[0], (int)values[1], (int)values[2], (int)values[3]);
            }
            if (Dimension.class.equals((Object)type)) {
                double[] values = this.convert((String)value, 2, "x");
                if (values == null) {
                    throw new IllegalArgumentException("Invalid format");
                }
                Dimension dim = new Dimension();
                dim.setSize(values[0], values[1]);
                return dim;
            }
            if (Point.class.equals((Object)type)) {
                double[] values = this.convert((String)value, 2, " ");
                if (values == null) {
                    throw new IllegalArgumentException("Invalid format");
                }
                Point p = new Point();
                p.setLocation(values[0], values[1]);
                return p;
            }
        }
        return null;
    }

    private double[] convert(String text, int tokenCount, String delimiters) {
        StringTokenizer tokenizer = new StringTokenizer(text, delimiters);
        if (tokenizer.countTokens() != tokenCount) {
            return null;
        }
        try {
            double[] values = new double[tokenCount];
            int i = 0;
            while (tokenizer.hasMoreTokens()) {
                values[i] = Double.parseDouble(tokenizer.nextToken());
                ++i;
            }
            return values;
        }
        catch (Exception e) {
            return null;
        }
    }
}

