/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.swing.renderer;

import com.l2fprod.common.annotations.RendererRegistry;
import com.l2fprod.common.beans.editor.DateStringPropertyEditor;
import com.l2fprod.common.swing.renderer.DefaultCellRenderer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

@RendererRegistry(type={Date.class})
public class DateRenderer
extends DefaultCellRenderer {
    private DateFormat dateFormat;

    public DateRenderer() {
        this(DateStringPropertyEditor.DEFAULT_DATE_FORMAT);
    }

    public DateRenderer(String formatString) {
        this(formatString, Locale.getDefault());
    }

    public DateRenderer(Locale l) {
        this(DateFormat.getDateInstance(3, l));
    }

    public DateRenderer(String formatString, Locale l) {
        this(new SimpleDateFormat(formatString, l));
    }

    public DateRenderer(DateFormat dateFormat) {
        this.dateFormat = dateFormat;
    }

    @Override
    public void setValue(Object value) {
        if (value == null) {
            this.setText("");
        } else {
            this.setText(this.dateFormat.format((Date)value));
        }
    }
}

