/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.swing;

import com.l2fprod.common.swing.table.TableHelper;
import com.l2fprod.common.util.converter.ConverterRegistry;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.DefaultButtonModel;
import javax.swing.JFileChooser;
import javax.swing.JRadioButton;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.text.JTextComponent;

public class UserPreferences {
    private static final ComponentListener windowDimension = new ComponentAdapter(){

        @Override
        public void componentMoved(ComponentEvent e) {
            this.store((Window)e.getComponent());
        }

        @Override
        public void componentResized(ComponentEvent e) {
            this.store((Window)e.getComponent());
        }

        private void store(Window w) {
            String bounds = (String)ConverterRegistry.instance().convert(String.class, w.getBounds());
            UserPreferences.node().node("Windows").put(w.getName() + ".bounds", bounds);
        }
    };
    private static final PropertyChangeListener splitPaneListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            JSplitPane split = (JSplitPane)evt.getSource();
            UserPreferences.node().node("JSplitPane").put(split.getName() + ".dividerLocation", String.valueOf(split.getDividerLocation()));
        }
    };

    public static JFileChooser getDefaultFileChooser() {
        return UserPreferences.getFileChooser("default");
    }

    public static JFileChooser getDefaultDirectoryChooser() {
        return UserPreferences.getDirectoryChooser("default");
    }

    public static JFileChooser getFileChooser(String id) {
        JFileChooser chooser = new JFileChooser();
        UserPreferences.track(chooser, "FileChooser." + id + ".path");
        return chooser;
    }

    public static JFileChooser getDirectoryChooser(String id) {
        JFileChooser chooser;
        try {
            Class<?> directoryChooserClass = Class.forName("com.l2fprod.common.swing.JDirectoryChooser");
            chooser = (JFileChooser)directoryChooserClass.newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            chooser = new JFileChooser();
            chooser.setFileSelectionMode(1);
        }
        UserPreferences.track(chooser, "DirectoryChooser." + id + ".path");
        return chooser;
    }

    private static void track(JFileChooser chooser, final String key) {
        File file;
        String path = UserPreferences.node().get(key, null);
        if (path != null && (file = new File(path)).exists()) {
            chooser.setCurrentDirectory(file);
        }
        PropertyChangeListener trackPath = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue() instanceof File) {
                    UserPreferences.node().put(key, ((File)evt.getNewValue()).getAbsolutePath());
                }
            }
        };
        chooser.addPropertyChangeListener("directoryChanged", trackPath);
    }

    public static void track(final JRadioButton button) {
        final Preferences prefs = UserPreferences.node().node("Buttons");
        boolean selected = prefs.getBoolean(button.getName() + ".selected", button.isSelected());
        ((DefaultButtonModel)button.getModel()).getGroup().setSelected(button.getModel(), selected);
        button.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                prefs.putBoolean(button.getName() + ".selected", button.isSelected());
            }
        });
    }

    public static void track(Window window) {
        Preferences prefs = UserPreferences.node().node("Windows");
        String bounds = prefs.get(window.getName() + ".bounds", null);
        if (bounds != null) {
            Rectangle rect = (Rectangle)ConverterRegistry.instance().convert(Rectangle.class, bounds);
            window.setBounds(rect);
        }
        window.addComponentListener(windowDimension);
    }

    public static void track(JTable table) {
        try {
            Preferences prefs = UserPreferences.node().node("Tables").node(table.getName() + ".columnWidths");
            TableColumnModel model = table.getTableHeader().getColumnModel();
            int c = model.getColumnCount();
            for (int i = 0; i < c; ++i) {
                TableColumn column = model.getColumn(i);
                int width = prefs.getInt(table.getColumnName(i), -1);
                if (width == -1) continue;
                column.setPreferredWidth(width);
            }
            table.getTableHeader().resizeAndRepaint();
        }
        catch (Throwable e) {
            Logger.getLogger(UserPreferences.class.getName()).log(Level.SEVERE, null, e);
        }
        try {
            TableHelper.addColumnModelTracker(table, new TableWidthTracker(table));
        }
        catch (Throwable e) {
            Logger.getLogger(UserPreferences.class.getName()).log(Level.SEVERE, null, e);
        }
    }

    public static void track(JTextComponent text) {
        TextListener textListener = new TextListener(text);
    }

    public static void track(JSplitPane split) {
        Preferences prefs = UserPreferences.node().node("JSplitPane");
        int dividerLocation = prefs.getInt(split.getName() + ".dividerLocation", -1);
        if (dividerLocation >= 0) {
            split.setDividerLocation(dividerLocation);
        }
        split.addPropertyChangeListener("dividerLocation", splitPaneListener);
    }

    private static Preferences node() {
        return Preferences.userNodeForPackage(UserPreferences.class).node("UserPreferences");
    }

    private static class TextListener
    implements DocumentListener {
        private final JTextComponent text;

        public TextListener(JTextComponent text) {
            this.text = text;
            this.restore();
            text.getDocument().addDocumentListener(this);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.store();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.store();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.store();
        }

        void restore() {
            Preferences prefs = UserPreferences.node().node("JTextComponent");
            this.text.setText(prefs.get(this.text.getName(), ""));
        }

        void store() {
            Preferences prefs = UserPreferences.node().node("JTextComponent");
            prefs.put(this.text.getName(), this.text.getText());
        }
    }

    private static class TableWidthTracker
    implements TableColumnModelListener {
        private final JTable table;

        public TableWidthTracker(JTable table) {
            this.table = table;
        }

        void saveColumnWidths() {
            try {
                Preferences prefs = UserPreferences.node().node("Tables").node(this.table.getName() + ".columnWidths");
                prefs.clear();
                TableColumnModel model = this.table.getTableHeader().getColumnModel();
                int c = model.getColumnCount();
                for (int i = 0; i < c; ++i) {
                    TableColumn column = model.getColumn(i);
                    prefs.putInt(this.table.getColumnName(i), column.getWidth());
                }
            }
            catch (BackingStoreException e) {
                Logger.getLogger(UserPreferences.class.getName()).log(Level.SEVERE, null, e);
            }
        }

        @Override
        public void columnAdded(TableColumnModelEvent event) {
            this.saveColumnWidths();
        }

        @Override
        public void columnMarginChanged(ChangeEvent event) {
            this.saveColumnWidths();
        }

        @Override
        public void columnMoved(TableColumnModelEvent event) {
            this.saveColumnWidths();
        }

        @Override
        public void columnRemoved(TableColumnModelEvent event) {
            this.saveColumnWidths();
        }

        @Override
        public void columnSelectionChanged(ListSelectionEvent event) {
            this.saveColumnWidths();
        }
    }
}

