/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.swing;

import com.l2fprod.common.swing.LookAndFeelTweaks;
import java.awt.Color;
import java.awt.Component;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.UIResource;

public class StatusBar
extends JComponent {
    public static final String DEFAULT_ZONE = "default";
    private final HashMap<String, Component> idToZones;
    private Border zoneBorder;

    public StatusBar() {
        this.setLayout(LookAndFeelTweaks.createHorizontalPercentLayout());
        this.idToZones = new HashMap();
        this.setZoneBorder(BorderFactory.createLineBorder(Color.lightGray));
    }

    public void setZoneBorder(Border border) {
        this.zoneBorder = border;
    }

    public void addZone(String id, Component zone, String constraints) {
        JComponent jc;
        Component previousZone = this.getZone(id);
        if (previousZone != null) {
            this.remove(previousZone);
            this.idToZones.remove(id);
        }
        if (zone instanceof JComponent && ((jc = (JComponent)zone).getBorder() == null || jc.getBorder() instanceof UIResource)) {
            if (jc instanceof JLabel) {
                jc.setBorder(new CompoundBorder(this.zoneBorder, new EmptyBorder(0, 2, 0, 2)));
                ((JLabel)jc).setText(" ");
            } else {
                jc.setBorder(this.zoneBorder);
            }
        }
        this.add(zone, constraints);
        this.idToZones.put(id, zone);
    }

    public Component getZone(String id) {
        return this.idToZones.get(id);
    }

    public void setZones(String[] ids, Component[] zones, String[] constraints) {
        this.removeAll();
        this.idToZones.clear();
        int c = zones.length;
        for (int i = 0; i < c; ++i) {
            this.addZone(ids[i], zones[i], constraints[i]);
        }
    }
}

