/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.beans;

import com.l2fprod.common.model.DefaultBeanInfoResolver;
import com.l2fprod.common.propertysheet.Property;
import com.l2fprod.common.propertysheet.PropertySheetPanel;
import java.beans.BeanInfo;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.UIManager;

public class BeanBinder {
    private final Object bean;
    private final PropertySheetPanel sheet;
    private final PropertyChangeListener listener;

    public BeanBinder(Object bean, PropertySheetPanel sheet) {
        this(bean, sheet, new DefaultBeanInfoResolver().getBeanInfo(bean));
    }

    public BeanBinder(final Object bean, final PropertySheetPanel sheet, BeanInfo beanInfo) {
        this.bean = bean;
        this.sheet = sheet;
        sheet.setProperties(beanInfo.getPropertyDescriptors());
        sheet.readFromObject(bean);
        final AtomicBoolean fire = new AtomicBoolean(true);
        this.listener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                block3: {
                    if (fire.get()) {
                        fire.set(false);
                        Property prop = (Property)evt.getSource();
                        try {
                            prop.writeToObject(BeanBinder.this.bean);
                            sheet.readFromObject(bean);
                        }
                        catch (RuntimeException e) {
                            if (!(e.getCause() instanceof PropertyVetoException)) break block3;
                            UIManager.getLookAndFeel().provideErrorFeedback(BeanBinder.this.sheet);
                            prop.setValue(evt.getOldValue());
                        }
                    }
                }
                fire.set(true);
            }
        };
        sheet.addPropertySheetChangeListener(this.listener);
    }

    public void update() {
        this.sheet.readFromObject(this.bean);
    }

    public void unbind() {
        this.sheet.removePropertyChangeListener(this.listener);
        this.sheet.setProperties(new Property[0]);
    }
}

