/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.beans;

import com.l2fprod.common.beans.DefaultBeanDescriptor;
import com.l2fprod.common.beans.ExtendedPropertyDescriptor;
import com.l2fprod.common.util.ResourceManager;
import java.awt.Image;
import java.beans.BeanDescriptor;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.beans.SimpleBeanInfo;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.MissingResourceException;

public class BaseBeanInfo
extends SimpleBeanInfo {
    private final Class type;
    private BeanDescriptor beanDescriptor;
    private final List properties = new ArrayList(0);

    public BaseBeanInfo(Class type) {
        this.type = type;
    }

    public final Class getType() {
        return this.type;
    }

    public ResourceManager getResources() {
        return ResourceManager.get(this.getType());
    }

    @Override
    public BeanDescriptor getBeanDescriptor() {
        if (this.beanDescriptor == null) {
            this.beanDescriptor = new DefaultBeanDescriptor(this);
        }
        return this.beanDescriptor;
    }

    @Override
    public PropertyDescriptor[] getPropertyDescriptors() {
        return this.properties.toArray(new PropertyDescriptor[0]);
    }

    public int getPropertyDescriptorCount() {
        return this.properties.size();
    }

    public PropertyDescriptor getPropertyDescriptor(int index) {
        return (PropertyDescriptor)this.properties.get(index);
    }

    protected PropertyDescriptor addPropertyDescriptor(PropertyDescriptor property) {
        this.properties.add(property);
        return property;
    }

    public ExtendedPropertyDescriptor addProperty(String propertyName) {
        try {
            if (propertyName == null || propertyName.trim().length() == 0) {
                throw new IntrospectionException("bad property name");
            }
            ExtendedPropertyDescriptor descriptor = ExtendedPropertyDescriptor.newPropertyDescriptor(propertyName, this.getType());
            try {
                descriptor.setDisplayName(this.getResources().getString(propertyName));
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            try {
                descriptor.setShortDescription(this.getResources().getString(propertyName + ".shortDescription"));
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            this.addPropertyDescriptor(descriptor);
            return descriptor;
        }
        catch (IntrospectionException e) {
            throw new RuntimeException(e);
        }
    }

    public PropertyDescriptor removeProperty(String propertyName) {
        if (propertyName == null) {
            throw new IllegalArgumentException("Property name can not be null");
        }
        Iterator iter = this.properties.iterator();
        while (iter.hasNext()) {
            PropertyDescriptor property = (PropertyDescriptor)iter.next();
            if (!propertyName.equals(property.getName())) continue;
            iter.remove();
            return property;
        }
        return null;
    }

    @Override
    public Image getIcon(int kind) {
        return null;
    }

    public String getText(Object value) {
        return value.toString();
    }

    public String getDescription(Object value) {
        return this.getText(value);
    }

    public String getToolTipText(Object value) {
        return this.getText(value);
    }
}

