/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.util.converter;

import com.l2fprod.common.util.converter.Converter;
import com.l2fprod.common.util.converter.Registry;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;

public final class ConverterRegistry
implements Registry {
    private static final ConverterRegistry sharedInstance = new ConverterRegistry();
    private final Map<Class<?>, Map<Class<?>, Converter>> fromMap = new HashMap();

    private ConverterRegistry() {
        ServiceLoader<Converter> loader = ServiceLoader.load(Converter.class);
        Iterator<Converter> iterator = loader.iterator();
        while (iterator.hasNext()) {
            iterator.next().register(this);
        }
    }

    public void addConverter(Class from, Class to, Converter converter) {
        Map<Class<?>, Converter> toMap = this.fromMap.get(from);
        if (toMap == null) {
            toMap = new HashMap();
            this.fromMap.put(from, toMap);
        }
        toMap.put(to, converter);
    }

    public Converter getConverter(Class from, Class to) {
        Map<Class<?>, Converter> toMap = this.fromMap.get(from);
        if (toMap != null) {
            return toMap.get(to);
        }
        return null;
    }

    public Object convert(Class targetType, Object value) {
        if (value == null) {
            return null;
        }
        Converter converter = this.getConverter((Class)value.getClass(), targetType);
        if (converter == null) {
            throw new IllegalArgumentException("No converter from " + value.getClass() + " to " + targetType.getName());
        }
        return converter.convert(targetType, value);
    }

    public static ConverterRegistry instance() {
        return sharedInstance;
    }
}

