/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.swing;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class IconPool {
    private static final IconPool iconPool = new IconPool();
    private final Map pool = new HashMap();

    public static IconPool shared() {
        return iconPool;
    }

    public Icon get(String url) {
        StackTraceElement[] stacks = new Exception().getStackTrace();
        try {
            Class<?> callerClazz = Class.forName(stacks[1].getClassName());
            return this.get(callerClazz.getResource(url));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized Icon get(URL url) {
        if (url == null) {
            return null;
        }
        Icon icon = (Icon)this.pool.get(url.toString());
        if (icon == null) {
            icon = new ImageIcon(url);
            this.pool.put(url.toString(), icon);
        }
        return icon;
    }

    public synchronized void clear() {
        this.pool.clear();
    }
}

