/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.propertysheet;

import com.l2fprod.common.annotations.EditorRegistry;
import com.l2fprod.common.annotations.PropertyEditorOverride;
import com.l2fprod.common.propertysheet.Property;
import com.l2fprod.common.propertysheet.PropertyDescriptorAdapter;
import com.l2fprod.common.propertysheet.PropertyEditorFactory;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class PropertyEditorRegistry
implements PropertyEditorFactory {
    private final Map typeToEditor = new HashMap();
    private final Map propertyToEditor = new HashMap();
    public static final PropertyEditorRegistry Instance = new PropertyEditorRegistry();

    private PropertyEditorRegistry() {
        this.registerDefaults();
    }

    @Override
    public PropertyEditor createPropertyEditor(Property property) {
        return this.getEditor(property);
    }

    public synchronized PropertyEditor getEditor(Property property) {
        PropertyDescriptor descriptor;
        PropertyEditor editor = null;
        if (property instanceof PropertyDescriptorAdapter && (descriptor = ((PropertyDescriptorAdapter)property).getDescriptor()) != null) {
            Class<?> clz;
            PropertyEditorOverride annotation = descriptor.getWriteMethod().getAnnotation(PropertyEditorOverride.class);
            if (annotation != null && (clz = annotation.type()) != null) {
                editor = this.loadPropertyEditor(clz);
            }
            if (editor == null && (clz = descriptor.getPropertyEditorClass()) != null) {
                editor = this.loadPropertyEditor(clz);
            }
        }
        if (editor == null) {
            Object value = this.propertyToEditor.get(property);
            editor = value instanceof PropertyEditor ? (PropertyEditor)value : (value instanceof Class ? this.loadPropertyEditor((Class)value) : this.getEditor(property.getType()));
        }
        if (editor == null && property instanceof PropertyDescriptorAdapter) {
            descriptor = ((PropertyDescriptorAdapter)property).getDescriptor();
            Class<?> clz = descriptor.getPropertyType();
            editor = PropertyEditorManager.findEditor(clz);
        }
        return editor;
    }

    private PropertyEditor loadPropertyEditor(Class clz) {
        PropertyEditor editor = null;
        try {
            editor = (PropertyEditor)clz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            Logger.getLogger(PropertyEditorRegistry.class.getName()).log(Level.SEVERE, null, e);
        }
        return editor;
    }

    public synchronized PropertyEditor getEditor(Class type) {
        PropertyEditor editor = null;
        Object value = this.typeToEditor.get(type);
        if (value == null && type.isEnum()) {
            value = this.typeToEditor.get(Enum.class);
        }
        if (value instanceof PropertyEditor) {
            editor = (PropertyEditor)value;
        } else if (value instanceof Class) {
            try {
                editor = (PropertyEditor)((Class)value).newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                Logger.getLogger(PropertyEditorRegistry.class.getName()).log(Level.SEVERE, null, e);
            }
        }
        return editor;
    }

    public synchronized void registerEditor(Class type, Class editorClass) {
        this.typeToEditor.put(type, editorClass);
    }

    public synchronized void registerEditor(Class type, PropertyEditor editor) {
        this.typeToEditor.put(type, editor);
    }

    public synchronized void unregisterEditor(Class type) {
        this.typeToEditor.remove(type);
    }

    public synchronized void registerEditor(Property property, Class editorClass) {
        this.propertyToEditor.put(property, editorClass);
    }

    public synchronized void registerEditor(Property property, PropertyEditor editor) {
        this.propertyToEditor.put(property, editor);
    }

    public synchronized void unregisterEditor(Property property) {
        this.propertyToEditor.remove(property);
    }

    public void registerDefaults() {
        this.typeToEditor.clear();
        this.propertyToEditor.clear();
        ServiceLoader<PropertyEditor> propertyLoader = ServiceLoader.load(PropertyEditor.class);
        try {
            for (PropertyEditor c : propertyLoader) {
                EditorRegistry annotation = c.getClass().getAnnotation(EditorRegistry.class);
                if (annotation == null) continue;
                for (Class clazz : annotation.type()) {
                    this.registerEditor(clazz, c.getClass());
                }
            }
        }
        catch (ServiceConfigurationError serviceConfigurationError) {
            // empty catch block
        }
    }
}

