/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.demo;

import com.l2fprod.common.annotations.PropertyEditorOverride;
import com.l2fprod.common.annotations.PropertyRendererOverride;
import com.l2fprod.common.beans.BeanBinder;
import com.l2fprod.common.beans.editor.ComboBoxPropertyEditor;
import com.l2fprod.common.demo.PropertySheetMain;
import com.l2fprod.common.propertysheet.PropertySheetPanel;
import com.l2fprod.common.swing.LookAndFeelTweaks;
import com.l2fprod.common.swing.renderer.DefaultCellRenderer;
import java.awt.Color;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.io.File;
import java.util.Arrays;
import java.util.Calendar;
import java.util.ListResourceBundle;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.UIManager;

public class PropertySheetPage
extends JPanel {
    public PropertySheetPage() {
        this.setLayout(LookAndFeelTweaks.createVerticalPercentLayout());
        JTextArea message = new JTextArea();
        message.setText(PropertySheetMain.RESOURCE.getString("Main.sheet1.message"));
        LookAndFeelTweaks.makeMultilineLabel(message);
        this.add(message);
        Bean data = new Bean();
        data.setName("John Smith");
        data.setText("Any text here");
        data.setColor(Color.green);
        data.setPath(new File("."));
        data.setVisible(true);
        data.setTime(System.currentTimeMillis());
        data.setCalendar(Calendar.getInstance());
        PropertySheetPanel sheet = new PropertySheetPanel();
        sheet.setMode(1);
        sheet.setDescriptionVisible(true);
        sheet.setSortingCategories(true);
        sheet.setSortingProperties(true);
        sheet.setRestoreToggleStates(true);
        this.add((Component)sheet, "*");
        new BeanBinder(data, sheet);
    }

    public static class BeanRB
    extends ListResourceBundle {
        @Override
        protected Object[][] getContents() {
            return new Object[][]{{"name", "Name"}, {"name.shortDescription", "The name of this object<br>Here I'm using multple lines<br>for the property<br>so scrollbars will get enabled"}, {"text", "Text"}, {"time", "Time"}, {"color", "Background"}, {"aDouble", "a double"}, {"season", "Season"}, {"constrained.shortDescription", "This property is constrained. Try using <b>blah</b> as the value, the previous value will be restored"}};
        }
    }

    public static class SeasonRenderer
    extends DefaultCellRenderer {
        @Override
        public void setValue(Object value) {
            if (value == null) {
                this.setText("");
            } else {
                this.setText(value + " STRING");
            }
        }
    }

    public static class SeasonEditor
    extends ComboBoxPropertyEditor {
        public SeasonEditor() {
            this.setAvailableValues(new String[]{"Spring", "Summer", "Fall", "Winter"});
            Object[] icons = new Icon[4];
            Arrays.fill(icons, UIManager.getIcon("Tree.openIcon"));
            this.setAvailableIcons((Icon[])icons);
        }
    }

    public static class Bean {
        private Calendar calendar;
        private String name;
        private String text;
        private long time;
        private boolean visible;
        private int id;
        private File path;
        private Color color = Color.blue;
        private double doubleValue = 121210.4343543;
        private Seasons seasonEnum = Seasons.SUMMER;
        private String season = "SUMMER";
        private String constrained;

        public Calendar getCalendar() {
            return this.calendar;
        }

        public void setCalendar(Calendar value) {
            this.calendar = value;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }

        public long getTime() {
            return this.time;
        }

        public void setTime(long time) {
            this.time = time;
        }

        public String getVersion() {
            return "1.0";
        }

        public boolean isVisible() {
            return this.visible;
        }

        public void setVisible(boolean visible) {
            this.visible = visible;
        }

        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }

        public File getPath() {
            return this.path;
        }

        public void setPath(File path) {
            this.path = path;
        }

        public Color getColor() {
            return this.color;
        }

        public void setColor(Color color) {
            this.color = color;
        }

        public void setADouble(double d) {
            this.doubleValue = d;
        }

        public double getADouble() {
            return this.doubleValue;
        }

        public void setSeasonEnum(Seasons s) {
            this.seasonEnum = s;
        }

        public Seasons getSeasonEnum() {
            return this.seasonEnum;
        }

        @PropertyEditorOverride(type=SeasonEditor.class)
        public void setSeason(String s) {
            this.season = s;
        }

        @PropertyRendererOverride(type=SeasonRenderer.class)
        public String getSeason() {
            return this.season;
        }

        public String getConstrained() {
            return this.constrained;
        }

        public void setConstrained(String constrained) throws PropertyVetoException {
            if ("blah".equals(constrained)) {
                throw new PropertyVetoException("e", new PropertyChangeEvent(this, "constrained", this.constrained, constrained));
            }
            this.constrained = constrained;
        }

        public String toString() {
            return "[name=" + this.getName() + ",text=" + this.getText() + ",time=" + this.getTime() + ",version=" + this.getVersion() + ",visible=" + this.isVisible() + ",id=" + this.getId() + ",path=" + this.getPath() + ",aDouble=" + this.getADouble() + ",season=" + this.getSeason() + "]";
        }
    }

    public static enum Seasons {
        SUMMER,
        FALL,
        WINTER,
        SPRING;

    }
}

