/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.beans.editor;

import com.l2fprod.common.beans.editor.AbstractPropertyEditor;
import com.l2fprod.common.swing.LookAndFeelTweaks;
import com.l2fprod.common.util.converter.ConverterRegistry;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;

public abstract class StringConverterPropertyEditor
extends AbstractPropertyEditor {
    private Object oldValue;

    public StringConverterPropertyEditor() {
        this.editor = new JTextField();
        ((JTextField)this.editor).setBorder(LookAndFeelTweaks.EMPTY_BORDER);
    }

    @Override
    public Object getValue() {
        String text = ((JTextComponent)this.editor).getText();
        if (text == null || text.trim().length() == 0) {
            return null;
        }
        try {
            return this.convertFromString(text.trim());
        }
        catch (Exception e) {
            return this.oldValue;
        }
    }

    @Override
    public void setValue(Object value) {
        if (value == null) {
            ((JTextComponent)this.editor).setText("");
        } else {
            this.oldValue = value;
            ((JTextComponent)this.editor).setText(this.convertToString(value));
        }
    }

    protected abstract Object convertFromString(String var1);

    protected String convertToString(Object value) {
        return (String)ConverterRegistry.instance().convert(String.class, value);
    }
}

