/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.beans.editor;

import com.l2fprod.common.beans.editor.FilePropertyEditor;
import com.l2fprod.common.swing.UserPreferences;
import com.l2fprod.common.util.ResourceManager;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFileChooser;

public class DirectoryPropertyEditor
extends FilePropertyEditor {
    @Override
    protected void selectFile() {
        ResourceManager rm = ResourceManager.all(FilePropertyEditor.class);
        JFileChooser chooser = UserPreferences.getDefaultDirectoryChooser();
        chooser.setDialogTitle(rm.getString("DirectoryPropertyEditor.dialogTitle"));
        chooser.setApproveButtonText(rm.getString("DirectoryPropertyEditor.approveButtonText"));
        chooser.setApproveButtonMnemonic(rm.getChar("DirectoryPropertyEditor.approveButtonMnemonic"));
        Object x = this.getValue();
        File oldFile = File.class.isAssignableFrom(x.getClass()) ? (File)x : new File((String)x);
        if (oldFile != null && oldFile.isDirectory()) {
            try {
                chooser.setCurrentDirectory(oldFile.getCanonicalFile());
            }
            catch (IOException e) {
                Logger.getLogger(DirectoryPropertyEditor.class.getName()).log(Level.SEVERE, null, e);
            }
        }
        if (0 == chooser.showOpenDialog(this.editor)) {
            File newFile = chooser.getSelectedFile();
            String text = newFile.getAbsolutePath();
            this.textfield.setText(text);
            if (String.class.isAssignableFrom(x.getClass())) {
                this.firePropertyChange(oldFile.getAbsolutePath(), newFile.getAbsolutePath());
            } else {
                this.firePropertyChange(oldFile, newFile);
            }
        }
    }
}

