/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.propertysheet;

import com.l2fprod.common.propertysheet.Property;
import com.l2fprod.common.propertysheet.PropertySheet;
import com.l2fprod.common.swing.ObjectTableModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.table.AbstractTableModel;

public class PropertySheetTableModel
extends AbstractTableModel
implements PropertyChangeListener,
PropertySheet,
ObjectTableModel {
    public static final int NAME_COLUMN = 0;
    public static final int VALUE_COLUMN = 1;
    public static final int NUM_COLUMNS = 2;
    private PropertyChangeSupport listeners = new PropertyChangeSupport(this);
    private List model = new ArrayList();
    private List publishedModel = new ArrayList();
    private List properties = new ArrayList();
    private int mode = 0;
    private boolean sortingCategories = false;
    private boolean sortingProperties = false;
    private boolean restoreToggleStates = false;
    private Comparator categorySortingComparator;
    private Comparator propertySortingComparator;
    private Map toggleStates = new HashMap();
    private static final Comparator STRING_COMPARATOR = new NaturalOrderStringComparator();

    @Override
    public void setProperties(Property[] newProperties) {
        for (Property prop : this.properties) {
            prop.removePropertyChangeListener(this);
        }
        this.properties.clear();
        this.properties.addAll(Arrays.asList(newProperties));
        for (Property prop : this.properties) {
            prop.addPropertyChangeListener(this);
        }
        this.buildModel();
    }

    @Override
    public Property[] getProperties() {
        return this.properties.toArray(new Property[this.properties.size()]);
    }

    @Override
    public void addProperty(Property property) {
        this.properties.add(property);
        property.addPropertyChangeListener(this);
        this.buildModel();
    }

    @Override
    public void addProperty(int index, Property property) {
        this.properties.add(index, property);
        property.addPropertyChangeListener(this);
        this.buildModel();
    }

    @Override
    public void removeProperty(Property property) {
        this.properties.remove(property);
        property.removePropertyChangeListener(this);
        this.buildModel();
    }

    @Override
    public int getPropertyCount() {
        return this.properties.size();
    }

    @Override
    public Iterator propertyIterator() {
        return this.properties.iterator();
    }

    public void setMode(int mode) {
        if (this.mode == mode) {
            return;
        }
        this.mode = mode;
        this.buildModel();
    }

    public int getMode() {
        return this.mode;
    }

    public Class getColumnClass(int columnIndex) {
        return super.getColumnClass(columnIndex);
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public int getRowCount() {
        return this.publishedModel.size();
    }

    @Override
    public Object getObject(int rowIndex) {
        return this.getPropertySheetElement(rowIndex);
    }

    public Item getPropertySheetElement(int rowIndex) {
        return (Item)this.publishedModel.get(rowIndex);
    }

    public boolean isSortingCategories() {
        return this.sortingCategories;
    }

    public void setSortingCategories(boolean value) {
        boolean old = this.sortingCategories;
        this.sortingCategories = value;
        if (this.sortingCategories != old) {
            this.buildModel();
        }
    }

    public boolean isSortingProperties() {
        return this.sortingProperties;
    }

    public void setSortingProperties(boolean value) {
        boolean old = this.sortingProperties;
        this.sortingProperties = value;
        if (this.sortingProperties != old) {
            this.buildModel();
        }
    }

    public void setCategorySortingComparator(Comparator comp) {
        Comparator old = this.categorySortingComparator;
        this.categorySortingComparator = comp;
        if (this.categorySortingComparator != old) {
            this.buildModel();
        }
    }

    public void setPropertySortingComparator(Comparator comp) {
        Comparator old = this.propertySortingComparator;
        this.propertySortingComparator = comp;
        if (this.propertySortingComparator != old) {
            this.buildModel();
        }
    }

    public void setRestoreToggleStates(boolean value) {
        this.restoreToggleStates = value;
        if (!this.restoreToggleStates) {
            this.toggleStates.clear();
        }
    }

    public boolean isRestoreToggleStates() {
        return this.restoreToggleStates;
    }

    public Map getToggleStates() {
        this.visibilityChanged(this.restoreToggleStates);
        return this.toggleStates;
    }

    public void setToggleStates(Map toggleStates) {
        this.setRestoreToggleStates(true);
        this.toggleStates.clear();
        this.toggleStates.putAll(toggleStates);
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Object result = null;
        Item item = this.getPropertySheetElement(rowIndex);
        if (item.isProperty()) {
            switch (columnIndex) {
                case 0: {
                    result = item;
                    break;
                }
                case 1: {
                    try {
                        result = item.getProperty().getValue();
                    }
                    catch (Exception e) {
                        Logger.getLogger(PropertySheetTableModel.class.getName()).log(Level.SEVERE, null, e);
                    }
                    break;
                }
            }
        } else {
            result = item;
        }
        return result;
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        Item item = this.getPropertySheetElement(rowIndex);
        if (item.isProperty() && columnIndex == 1) {
            try {
                item.getProperty().setValue(value);
            }
            catch (Exception e) {
                Logger.getLogger(PropertySheetTableModel.class.getName()).log(Level.SEVERE, null, e);
            }
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.removePropertyChangeListener(listener);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.listeners.firePropertyChange(evt);
    }

    protected void visibilityChanged(boolean restoreOldStates) {
        if (restoreOldStates) {
            for (Item item : this.publishedModel) {
                this.toggleStates.put(item.getKey(), item.isVisible() ? Boolean.TRUE : Boolean.FALSE);
            }
        }
        this.publishedModel.clear();
        for (Item item : this.model) {
            Item parent = item.getParent();
            if (restoreOldStates) {
                Boolean oldState = (Boolean)this.toggleStates.get(item.getKey());
                if (oldState != null) {
                    item.setVisible(oldState);
                }
                if (parent != null && (oldState = (Boolean)this.toggleStates.get(parent.getKey())) != null) {
                    parent.setVisible(oldState);
                }
            }
            if (parent != null && !parent.isVisible()) continue;
            this.publishedModel.add(item);
        }
    }

    private void buildModel() {
        this.model.clear();
        if (this.properties != null && this.properties.size() > 0) {
            List sortedProperties = this.sortProperties(this.properties);
            switch (this.mode) {
                case 0: {
                    this.addPropertiesToModel(sortedProperties, null);
                    break;
                }
                case 1: {
                    List categories = this.sortCategories(this.getPropertyCategories(sortedProperties));
                    for (String category : categories) {
                        Item categoryItem = new Item(category, null);
                        this.model.add(categoryItem);
                        this.addPropertiesToModel(this.sortProperties(this.getPropertiesForCategory(this.properties, category)), categoryItem);
                    }
                    break;
                }
            }
        }
        this.visibilityChanged(this.restoreToggleStates);
        this.fireTableDataChanged();
    }

    protected List sortProperties(List localProperties) {
        ArrayList sortedProperties = new ArrayList(localProperties);
        if (this.sortingProperties) {
            if (this.propertySortingComparator == null) {
                this.propertySortingComparator = new PropertyComparator();
            }
            Collections.sort(sortedProperties, this.propertySortingComparator);
        }
        return sortedProperties;
    }

    protected List sortCategories(List localCategories) {
        ArrayList sortedCategories = new ArrayList(localCategories);
        if (this.sortingCategories) {
            if (this.categorySortingComparator == null) {
                this.categorySortingComparator = STRING_COMPARATOR;
            }
            Collections.sort(sortedCategories, this.categorySortingComparator);
        }
        return sortedCategories;
    }

    protected List getPropertyCategories(List localProperties) {
        ArrayList<String> categories = new ArrayList<String>();
        for (Property property : localProperties) {
            if (categories.contains(property.getCategory())) continue;
            categories.add(property.getCategory());
        }
        return categories;
    }

    private void addPropertiesToModel(List localProperties, Item parent) {
        for (Property property : localProperties) {
            Item propertyItem = new Item(property, parent);
            this.model.add(propertyItem);
            Property[] subProperties = property.getSubProperties();
            if (subProperties == null || subProperties.length <= 0) continue;
            this.addPropertiesToModel(Arrays.asList(subProperties), propertyItem);
        }
    }

    private List getPropertiesForCategory(List localProperties, String category) {
        ArrayList<Property> categoryProperties = new ArrayList<Property>();
        for (Property property : localProperties) {
            if (category != property.getCategory() && (category == null || !category.equals(property.getCategory()))) continue;
            categoryProperties.add(property);
        }
        return categoryProperties;
    }

    public static class NaturalOrderStringComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            String s1 = (String)o1;
            String s2 = (String)o2;
            if (s1 == null) {
                return s2 == null ? 0 : -1;
            }
            if (s2 == null) {
                return 1;
            }
            return s1.compareTo(s2);
        }
    }

    public static class PropertyComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            if (o1 instanceof Property && o2 instanceof Property) {
                Property prop1 = (Property)o1;
                Property prop2 = (Property)o2;
                if (prop1 == null) {
                    return prop2 == null ? 0 : -1;
                }
                return STRING_COMPARATOR.compare(prop1.getDisplayName() == null ? null : prop1.getDisplayName().toLowerCase(), prop2.getDisplayName() == null ? null : prop2.getDisplayName().toLowerCase());
            }
            return 0;
        }
    }

    public class Item {
        private final String name;
        private Property property;
        private final Item parent;
        private boolean hasToggle = true;
        private boolean visible = true;

        private Item(String name, Item parent) {
            this.name = name;
            this.parent = parent;
            this.hasToggle = true;
        }

        private Item(Property property, Item parent) {
            this.name = property.getDisplayName();
            this.property = property;
            this.parent = parent;
            this.visible = property == null;
            Property[] subProperties = property.getSubProperties();
            this.hasToggle = subProperties != null && subProperties.length > 0;
        }

        public String getName() {
            return this.name;
        }

        public boolean isProperty() {
            return this.property != null;
        }

        public Property getProperty() {
            return this.property;
        }

        public Item getParent() {
            return this.parent;
        }

        public int getDepth() {
            int depth = 0;
            if (this.parent != null) {
                depth = this.parent.getDepth();
                if (this.parent.isProperty()) {
                    ++depth;
                }
            }
            return depth;
        }

        public boolean hasToggle() {
            return this.hasToggle;
        }

        public void toggle() {
            if (this.hasToggle()) {
                this.visible = !this.visible;
                PropertySheetTableModel.this.visibilityChanged(false);
                PropertySheetTableModel.this.fireTableDataChanged();
            }
        }

        public void setVisible(boolean visible) {
            this.visible = visible;
        }

        public boolean isVisible() {
            return !(this.parent != null && !this.parent.isVisible() || this.hasToggle && !this.visible);
        }

        public String getKey() {
            StringBuilder key = new StringBuilder(this.name);
            for (Item itemParent = this.parent; itemParent != null; itemParent = itemParent.getParent()) {
                key.append(":");
                key.append(itemParent.getName());
            }
            return key.toString();
        }
    }
}

