/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.propertysheet;

import com.l2fprod.common.annotations.PropertyRendererOverride;
import com.l2fprod.common.annotations.RendererRegistry;
import com.l2fprod.common.beans.ExtendedPropertyDescriptor;
import com.l2fprod.common.propertysheet.Property;
import com.l2fprod.common.propertysheet.PropertyDescriptorAdapter;
import com.l2fprod.common.propertysheet.PropertyRendererFactory;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.table.TableCellRenderer;

public final class PropertyRendererRegistry
implements PropertyRendererFactory {
    private final Map typeToRenderer = new HashMap();

    public PropertyRendererRegistry() {
        this.registerDefaults();
    }

    @Override
    public TableCellRenderer createTableCellRenderer(Property property) {
        return this.getRenderer(property);
    }

    @Override
    public TableCellRenderer createTableCellRenderer(Class type) {
        return this.getRenderer(type);
    }

    public synchronized TableCellRenderer getRenderer(Property property) {
        Object value;
        TableCellRenderer renderer = null;
        if (property instanceof PropertyDescriptorAdapter) {
            PropertyRendererOverride annotation;
            PropertyDescriptor descriptor = ((PropertyDescriptorAdapter)property).getDescriptor();
            Method readMethod = descriptor.getReadMethod();
            if (readMethod != null && (annotation = readMethod.getAnnotation(PropertyRendererOverride.class)) != null) {
                try {
                    return (TableCellRenderer)annotation.type().newInstance();
                }
                catch (IllegalAccessException | InstantiationException ex) {
                    Logger.getLogger(PropertyRendererRegistry.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            if (descriptor instanceof ExtendedPropertyDescriptor && ((ExtendedPropertyDescriptor)descriptor).getPropertyTableRendererClass() != null) {
                try {
                    return (TableCellRenderer)((ExtendedPropertyDescriptor)descriptor).getPropertyTableRendererClass().newInstance();
                }
                catch (IllegalAccessException | InstantiationException e) {
                    Logger.getLogger(PropertyRendererRegistry.class.getName()).log(Level.SEVERE, null, e);
                }
            }
        }
        if ((value = this.typeToRenderer.get(property)) instanceof TableCellRenderer) {
            renderer = (TableCellRenderer)value;
        } else if (value instanceof Class) {
            try {
                renderer = (TableCellRenderer)((Class)value).newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                Logger.getLogger(PropertyRendererRegistry.class.getName()).log(Level.SEVERE, null, e);
            }
        } else {
            renderer = this.getRenderer(property.getType());
        }
        return renderer;
    }

    public synchronized TableCellRenderer getRenderer(Class type) {
        TableCellRenderer renderer = null;
        Object value = this.typeToRenderer.get(type);
        if (value instanceof TableCellRenderer) {
            renderer = (TableCellRenderer)value;
        } else if (value instanceof Class) {
            try {
                renderer = (TableCellRenderer)((Class)value).newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                Logger.getLogger(PropertyRendererRegistry.class.getName()).log(Level.SEVERE, null, e);
            }
        }
        return renderer;
    }

    public synchronized void registerRenderer(Class type, Class rendererClass) {
        this.typeToRenderer.put(type, rendererClass);
    }

    public synchronized void registerRenderer(Class type, TableCellRenderer renderer) {
        this.typeToRenderer.put(type, renderer);
    }

    public synchronized void unregisterRenderer(Class type) {
        this.typeToRenderer.remove(type);
    }

    public void registerDefaults() {
        this.typeToRenderer.clear();
        ServiceLoader<TableCellRenderer> serviceLoader = ServiceLoader.load(TableCellRenderer.class);
        for (TableCellRenderer next : serviceLoader) {
            try {
                Method m;
                RendererRegistry annotation = next.getClass().getAnnotation(RendererRegistry.class);
                if (annotation != null) {
                    for (Class clazz : annotation.type()) {
                        this.registerRenderer(clazz, next);
                    }
                }
                if ((m = next.getClass().getMethod("setShowOddAndEvenRows", Boolean.TYPE)) == null) continue;
                m.invoke((Object)next, false);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {}
        }
    }
}

