/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.demo;

import com.l2fprod.common.demo.PropertySheetMain;
import com.l2fprod.common.propertysheet.DefaultProperty;
import com.l2fprod.common.propertysheet.Property;
import com.l2fprod.common.propertysheet.PropertySheetPanel;
import com.l2fprod.common.swing.LookAndFeelTweaks;
import com.l2fprod.common.util.ResourceManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class PropertySheetPage3
extends JPanel {
    private static final Class THIS_CLASS = PropertySheetPage3.class;
    static ResourceManager RESOURCE = ResourceManager.get(THIS_CLASS);

    public PropertySheetPage3() {
        this.setLayout(LookAndFeelTweaks.createVerticalPercentLayout());
        JTextArea message = new JTextArea();
        message.setText(PropertySheetMain.RESOURCE.getString("Main.sheet1.message"));
        LookAndFeelTweaks.makeMultilineLabel(message);
        this.add(message);
        final Colorful data = new Colorful();
        data.setColor(new Color(255, 153, 102));
        NoReadWriteProperty level0 = new NoReadWriteProperty();
        level0.setDisplayName("Level 0");
        level0.setCategory("A category");
        NoReadWriteProperty level1 = new NoReadWriteProperty();
        level1.setDisplayName("Level 1");
        level1.setCategory("Another category");
        level0.addSubProperty(level1);
        NoReadWriteProperty level2 = new NoReadWriteProperty();
        level2.setDisplayName("Level 2");
        level1.addSubProperty(level2);
        NoReadWriteProperty level21 = new NoReadWriteProperty();
        level21.setDisplayName("Level 3");
        level1.addSubProperty(level21);
        NoReadWriteProperty level211 = new NoReadWriteProperty();
        level211.setDisplayName("Level 3.1");
        level21.addSubProperty(level211);
        NoReadWriteProperty root = new NoReadWriteProperty();
        root.setDisplayName("Root");
        final PropertySheetPanel sheet = new PropertySheetPanel();
        sheet.setMode(0);
        sheet.setProperties(new Property[]{new ColorProperty(), level0, root});
        sheet.readFromObject(data);
        sheet.setDescriptionVisible(true);
        sheet.setSortingCategories(true);
        sheet.setSortingProperties(true);
        this.add((Component)sheet, "*");
        PropertyChangeListener listener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Property prop = (Property)evt.getSource();
                prop.writeToObject(data);
                System.out.println("Updated object to " + data);
            }
        };
        sheet.addPropertySheetChangeListener(listener);
        JButton button = new JButton(new AbstractAction("Click to setWantsExtraIndent(true)"){

            @Override
            public void actionPerformed(ActionEvent e) {
                sheet.getTable().setWantsExtraIndent(!sheet.getTable().getWantsExtraIndent());
                this.putValue("Name", "Click to setWantsExtraIndent(" + !sheet.getTable().getWantsExtraIndent() + ")");
            }
        });
        this.add(button);
    }

    public static class ColorComponentProperty
    extends DefaultProperty {
        public ColorComponentProperty(String name) {
            this.setName(name);
            this.setDisplayName(RESOURCE.getString(name + ".name"));
            this.setShortDescription(RESOURCE.getString(name + ".desc"));
            this.setType(Integer.TYPE);
        }
    }

    public static class ColorProperty
    extends DefaultProperty {
        public ColorProperty() {
            this.setName("color");
            this.setCategory(RESOURCE.getString("color.cat"));
            this.setDisplayName(RESOURCE.getString("color.name"));
            this.setShortDescription(RESOURCE.getString("color.desc"));
            this.setType(Color.class);
            this.addSubProperty(new ColorComponentProperty("red"));
            this.addSubProperty(new ColorComponentProperty("green"));
            this.addSubProperty(new ColorComponentProperty("blue"));
        }
    }

    public static class Colorful {
        private Color color;

        public Color getColor() {
            return this.color;
        }

        public void setColor(Color color) {
            this.color = color;
        }

        public int getRed() {
            return this.color.getRed();
        }

        public void setRed(int red) {
            this.color = new Color(red, this.getGreen(), this.getBlue());
        }

        public int getGreen() {
            return this.color.getGreen();
        }

        public void setGreen(int green) {
            this.color = new Color(this.getRed(), green, this.getBlue());
        }

        public int getBlue() {
            return this.color.getBlue();
        }

        public void setBlue(int blue) {
            this.color = new Color(this.getRed(), this.getGreen(), blue);
        }

        public String toString() {
            return this.color.toString();
        }
    }

    static class NoReadWriteProperty
    extends DefaultProperty {
        NoReadWriteProperty() {
        }

        @Override
        public void readFromObject(Object object) {
        }

        @Override
        public void writeToObject(Object object) {
        }
    }
}

