/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.propertysheet;

import com.l2fprod.common.annotations.RendererRegistry;
import com.l2fprod.common.beans.ExtendedPropertyDescriptor;
import com.l2fprod.common.propertysheet.Property;
import com.l2fprod.common.propertysheet.PropertyDescriptorAdapter;
import com.l2fprod.common.propertysheet.PropertyRendererFactory;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.table.TableCellRenderer;

public final class PropertyRendererRegistry
implements PropertyRendererFactory {
    private final Map typeToRenderer = new HashMap();
    private final Map propertyToRenderer = new HashMap();

    public PropertyRendererRegistry() {
        this.registerDefaults();
    }

    @Override
    public TableCellRenderer createTableCellRenderer(Property property) {
        return this.getRenderer(property);
    }

    @Override
    public TableCellRenderer createTableCellRenderer(Class type) {
        return this.getRenderer(type);
    }

    public synchronized TableCellRenderer getRenderer(Property property) {
        Object value;
        PropertyDescriptor descriptor;
        TableCellRenderer renderer = null;
        if (property instanceof PropertyDescriptorAdapter && (descriptor = ((PropertyDescriptorAdapter)property).getDescriptor()) instanceof ExtendedPropertyDescriptor && ((ExtendedPropertyDescriptor)descriptor).getPropertyTableRendererClass() != null) {
            try {
                return (TableCellRenderer)((ExtendedPropertyDescriptor)descriptor).getPropertyTableRendererClass().newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                Logger.getLogger(PropertyRendererRegistry.class.getName()).log(Level.SEVERE, null, e);
            }
        }
        if ((value = this.propertyToRenderer.get(property)) instanceof TableCellRenderer) {
            renderer = (TableCellRenderer)value;
        } else if (value instanceof Class) {
            try {
                renderer = (TableCellRenderer)((Class)value).newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                Logger.getLogger(PropertyRendererRegistry.class.getName()).log(Level.SEVERE, null, e);
            }
        } else {
            renderer = this.getRenderer(property.getType());
        }
        return renderer;
    }

    public synchronized TableCellRenderer getRenderer(Class type) {
        TableCellRenderer renderer = null;
        Object value = this.typeToRenderer.get(type);
        if (value instanceof TableCellRenderer) {
            renderer = (TableCellRenderer)value;
        } else if (value instanceof Class) {
            try {
                renderer = (TableCellRenderer)((Class)value).newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                Logger.getLogger(PropertyRendererRegistry.class.getName()).log(Level.SEVERE, null, e);
            }
        }
        return renderer;
    }

    public synchronized void registerRenderer(Class type, Class rendererClass) {
        this.typeToRenderer.put(type, rendererClass);
    }

    public synchronized void registerRenderer(Class type, TableCellRenderer renderer) {
        this.typeToRenderer.put(type, renderer);
    }

    public synchronized void unregisterRenderer(Class type) {
        this.typeToRenderer.remove(type);
    }

    public synchronized void registerRenderer(Property property, Class rendererClass) {
        this.propertyToRenderer.put(property, rendererClass);
    }

    public synchronized void registerRenderer(Property property, TableCellRenderer renderer) {
        this.propertyToRenderer.put(property, renderer);
    }

    public synchronized void unregisterRenderer(Property property) {
        this.propertyToRenderer.remove(property);
    }

    public void registerDefaults() {
        this.typeToRenderer.clear();
        this.propertyToRenderer.clear();
        ServiceLoader<TableCellRenderer> serviceLoader = ServiceLoader.load(TableCellRenderer.class);
        for (TableCellRenderer next : serviceLoader) {
            try {
                Method m;
                RendererRegistry annotation = next.getClass().getAnnotation(RendererRegistry.class);
                if (annotation != null) {
                    for (Class<?> clazz : annotation.type()) {
                        this.registerRenderer(clazz, next);
                    }
                }
                if ((m = next.getClass().getMethod("setShowOddAndEvenRows", Boolean.TYPE)) == null) continue;
                m.invoke((Object)next, false);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {}
        }
    }
}

