/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.beans.editor;

import com.l2fprod.common.annotations.EditorRegistry;
import com.l2fprod.common.beans.editor.AbstractPropertyEditor;
import com.l2fprod.common.swing.ComponentFactory;
import com.l2fprod.common.swing.LookAndFeelTweaks;
import com.l2fprod.common.swing.PercentLayout;
import com.l2fprod.common.swing.UserPreferences;
import com.l2fprod.common.util.ResourceManager;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.TransferHandler;

@EditorRegistry(type={File.class})
public class FilePropertyEditor
extends AbstractPropertyEditor {
    protected JTextField textfield;
    private JButton button;
    private boolean _treated_as_string = false;

    public FilePropertyEditor() {
        this(true);
    }

    public FilePropertyEditor(boolean asTableEditor) {
        this.editor = new JPanel(new PercentLayout(0, 0)){

            @Override
            public void setEnabled(boolean enabled) {
                super.setEnabled(enabled);
                FilePropertyEditor.this.textfield.setEnabled(enabled);
                FilePropertyEditor.this.button.setEnabled(enabled);
            }
        };
        this.textfield = new JTextField();
        ((JPanel)this.editor).add("*", this.textfield);
        this.button = ComponentFactory.Helper.getFactory().createMiniButton();
        ((JPanel)this.editor).add(this.button);
        if (asTableEditor) {
            this.textfield.setBorder(LookAndFeelTweaks.EMPTY_BORDER);
        }
        this.button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FilePropertyEditor.this.selectFile();
            }
        });
        this.textfield.setTransferHandler(new FileTransferHandler());
    }

    @Override
    public Object getValue() {
        if (this._treated_as_string) {
            return this.textfield.getText().trim();
        }
        if ("".equals(this.textfield.getText().trim())) {
            return null;
        }
        return new File(this.textfield.getText());
    }

    @Override
    public void setValue(Object value) {
        if (value != null) {
            if (File.class.isAssignableFrom(value.getClass())) {
                this.textfield.setText(((File)value).getAbsolutePath());
            } else if (String.class.isAssignableFrom(value.getClass())) {
                this._treated_as_string = true;
                this.textfield.setText((String)value);
            }
        }
    }

    protected void selectFile() {
        ResourceManager rm = ResourceManager.all(FilePropertyEditor.class);
        JFileChooser chooser = UserPreferences.getDefaultFileChooser();
        chooser.setDialogTitle(rm.getString("FilePropertyEditor.dialogTitle"));
        chooser.setApproveButtonText(rm.getString("FilePropertyEditor.approveButtonText"));
        chooser.setApproveButtonMnemonic(rm.getChar("FilePropertyEditor.approveButtonMnemonic"));
        this.customizeFileChooser(chooser);
        if (0 == chooser.showOpenDialog(this.editor)) {
            Object o = this.getValue();
            File oldFile = null;
            if (String.class.isAssignableFrom(o.getClass())) {
                oldFile = new File((String)o);
            } else if (File.class.isAssignableFrom(o.getClass())) {
                oldFile = (File)o;
            }
            File newFile = chooser.getSelectedFile();
            String text = newFile.getAbsolutePath();
            this.textfield.setText(text);
            if (this._treated_as_string) {
                this.firePropertyChange(oldFile.getAbsolutePath(), newFile.getAbsolutePath());
            } else {
                this.firePropertyChange(oldFile, newFile);
            }
        }
    }

    protected void customizeFileChooser(JFileChooser chooser) {
    }

    protected void selectNull() {
        Object oldFile = this.getValue();
        this.firePropertyChange(oldFile, oldFile);
    }

    class FileTransferHandler
    extends TransferHandler {
        FileTransferHandler() {
        }

        @Override
        public boolean canImport(JComponent comp, DataFlavor[] transferFlavors) {
            int c = transferFlavors.length;
            for (int i = 0; i < c; ++i) {
                if (!transferFlavors[i].equals(DataFlavor.javaFileListFlavor)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean importData(JComponent comp, Transferable t) {
            try {
                List list = (List)t.getTransferData(DataFlavor.javaFileListFlavor);
                if (list.size() > 0) {
                    File oldFile = (File)FilePropertyEditor.this.getValue();
                    File newFile = (File)list.get(0);
                    String text = newFile.getAbsolutePath();
                    FilePropertyEditor.this.textfield.setText(text);
                    FilePropertyEditor.this.firePropertyChange(oldFile, newFile);
                }
            }
            catch (UnsupportedFlavorException | IOException e) {
                Logger.getLogger(FilePropertyEditor.class.getName()).log(Level.SEVERE, null, e);
            }
            return true;
        }
    }
}

