/*
 * Decompiled with CFR 0.152.
 */
package org.torquebox.mojo.jruby9.war;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.shared.utils.io.IOUtil;
import org.codehaus.plexus.archiver.UnArchiver;
import org.torquebox.mojo.jruby9.ArchiveType;
import org.torquebox.mojo.jruby9.ArtifactHelper;

@Mojo(name="war", defaultPhase=LifecyclePhase.PACKAGE, requiresProject=true, threadSafe=true, requiresDependencyResolution=ResolutionScope.RUNTIME)
public class WarMojo
extends org.apache.maven.plugin.war.WarMojo {
    @Parameter(defaultValue="archive", property="jruby.archive.type", required=true)
    private ArchiveType type;
    @Parameter(required=false)
    private String mainClass;
    @Parameter(required=false, defaultValue="false")
    private boolean defaultResource;
    @Parameter(defaultValue="9.0.4.0", property="jruby.version", required=true)
    private String jrubyVersion;
    @Parameter(defaultValue="0.5.0", property="jruby.mains.version", required=true)
    private String jrubyMainsVersion;
    @Parameter(defaultValue="1.1.18", property="jruby.rack.version", required=true)
    private String jrubyRackVersion;
    @Parameter(defaultValue="8.1.16.v20140903", property="jetty.version", required=true)
    private String jettyVersion;
    @Parameter(readonly=true, required=true, defaultValue="${localRepository}")
    protected ArtifactRepository localRepository;
    @Component
    RepositorySystem system;
    @Component(hint="zip")
    UnArchiver unzip;

    public void execute() throws MojoExecutionException, MojoFailureException {
        ArtifactHelper helper = new ArtifactHelper(this.unzip, this.system, this.localRepository, this.getProject().getRemoteArtifactRepositories());
        File jrubyWar = new File(this.getProject().getBuild().getDirectory(), "jrubyWar");
        File jrubyWarLib = new File(jrubyWar, "lib");
        File webXml = new File(jrubyWar, "web.xml");
        File initRb = new File(jrubyWar, "init.rb");
        File jrubyWarClasses = new File(jrubyWar, "classes");
        switch (this.type) {
            case jetty: {
                helper.unzip(jrubyWarClasses, "org.eclipse.jetty", "jetty-server", this.jettyVersion);
                helper.unzip(jrubyWarClasses, "org.eclipse.jetty", "jetty-webapp", this.jettyVersion);
                if (this.mainClass == null) {
                    this.mainClass = "org.jruby.mains.JettyRunMain";
                }
            }
            case runnable: {
                helper.unzip(jrubyWarClasses, "org.jruby.mains", "jruby-mains", this.jrubyMainsVersion);
                if (this.mainClass == null) {
                    this.mainClass = "org.jruby.mains.WarMain";
                }
                MavenArchiveConfiguration archive = this.getArchive();
                archive.getManifest().setMainClass(this.mainClass);
                this.createAndAddWebResource(jrubyWarClasses, "");
                this.createAndAddWebResource(new File(this.getProject().getBuild().getOutputDirectory(), "bin"), "bin");
            }
        }
        helper.copy(jrubyWarLib, "org.jruby", "jruby-complete", this.jrubyVersion);
        helper.copy(jrubyWarLib, "org.jruby.rack", "jruby-rack", this.jrubyRackVersion, "org.jruby:jruby-complete");
        this.getProject().getArtifacts().clear();
        this.createAndAddWebResource(jrubyWarLib, "WEB-INF/lib");
        this.copyPluginResource(initRb);
        Resource resource = new Resource();
        resource.setDirectory(initRb.getParent());
        resource.addInclude(initRb.getName());
        resource.setTargetPath("META-INF");
        this.addWebResource(resource);
        if (this.defaultResource) {
            this.addCommonRackApplicationResources();
        }
        if (this.getWebXml() == null) {
            this.findWebXmlOrUseBuiltin(webXml);
        }
        super.execute();
    }

    private void addCommonRackApplicationResources() {
        Resource resource = new Resource();
        resource.setDirectory(this.getProject().getBasedir().getAbsolutePath());
        resource.addInclude("config.ru");
        this.getProject().addResource(resource);
        this.createAndAddResource(new File(this.getProject().getBasedir(), "lib"));
        this.createAndAddResource(new File(this.getProject().getBasedir(), "app"));
        this.createAndAddResource(new File(this.getProject().getBasedir(), "public"));
        this.createAndAddResource(new File(this.getProject().getBasedir(), "config"));
    }

    private void findWebXmlOrUseBuiltin(File webXml) throws MojoExecutionException {
        this.copyPluginResource(webXml);
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)("using builtin web.xml: " + webXml.toString().replace(this.getProject().getBasedir().getAbsolutePath() + File.separatorChar, "")));
        }
        this.setWebXml(webXml);
    }

    private void copyPluginResource(File file) throws MojoExecutionException {
        String name = file.getName();
        try {
            IOUtil.copy((InputStream)((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(name), (OutputStream)new FileOutputStream(file));
        }
        catch (IOException e) {
            throw new MojoExecutionException("could not copy from plugin: " + name, (Exception)e);
        }
    }

    private void createAndAddResource(File source) {
        this.getProject().addResource(this.createResource(source.getAbsolutePath(), null));
    }

    private void createAndAddWebResource(File source, String target) {
        this.addWebResource(this.createResource(source.getAbsolutePath(), target));
    }

    private void addWebResource(Resource resource) {
        Resource[] webResources = this.getWebResources();
        webResources = webResources == null ? new Resource[1] : Arrays.copyOf(webResources, webResources.length + 1);
        webResources[webResources.length - 1] = resource;
        this.setWebResources(webResources);
    }

    protected Resource createResource(String source, String target) {
        Resource resource = new Resource();
        resource.setDirectory(source);
        resource.addExclude("jetty*.css");
        resource.addExclude("plugin.properties");
        resource.addExclude("about.html");
        resource.addExclude("about_files/**");
        resource.addExclude("META-INF/ECLIPSE*");
        resource.addExclude("META-INF/eclipse*");
        resource.addExclude("META-INF/maven/**");
        resource.addExclude("WEB-INF/**");
        resource.addExclude("**/web.xml");
        if (target != null) {
            resource.setTargetPath(target);
        }
        return resource;
    }
}

