/*
 * Decompiled with CFR 0.152.
 */
package org.tools4j.nobark.run;

import java.util.Objects;
import java.util.concurrent.ThreadFactory;
import org.tools4j.nobark.run.RunnableFactory;
import org.tools4j.nobark.run.ThreadLike;
import sun.misc.Contended;

public class StoppableThread
implements ThreadLike {
    private final RunnableFactory runnableFactory;
    private final Thread thread;
    @Contended
    private volatile boolean running;

    protected StoppableThread(RunnableFactory runnableFactory, ThreadFactory threadFactory) {
        this.thread = threadFactory.newThread(this::run);
        this.runnableFactory = Objects.requireNonNull(runnableFactory);
        this.running = true;
        this.thread.start();
    }

    public static StoppableThread start(RunnableFactory runnableFactory, ThreadFactory threadFactory) {
        return new StoppableThread(runnableFactory, threadFactory);
    }

    private void run() {
        Runnable runnable = this.runnableFactory.create(this::keepRunning);
        runnable.run();
    }

    private boolean keepRunning() {
        return this.running;
    }

    @Override
    public Thread.State threadState() {
        return this.thread.getState();
    }

    @Override
    public void stop() {
        this.running = false;
    }

    @Override
    public void join(long millis) {
        try {
            this.thread.join(millis);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Join interrupted for thread " + this.thread);
        }
    }

    public String toString() {
        return this.thread.getName();
    }
}

