/*
 * Decompiled with CFR 0.152.
 */
package org.tools4j.nobark.run;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.tools4j.nobark.run.RunnableFactory;
import org.tools4j.nobark.run.Shutdownable;
import org.tools4j.nobark.run.ThreadLike;
import sun.misc.Contended;

public class ShutdownableThread
implements ThreadLike,
Shutdownable {
    private static final int RUNNING = 0;
    private static final int SHUTDOWN = 1;
    private static final int SHUTDOWN_NOW = 2;
    private final RunnableFactory mainRunnableFactory;
    private final RunnableFactory shutdownRunnableFactory;
    private final Thread thread;
    @Contended
    private final AtomicInteger state = new AtomicInteger(0);

    protected ShutdownableThread(RunnableFactory mainRunnableFactory, RunnableFactory shutdownRunnableFactory, ThreadFactory threadFactory) {
        this.mainRunnableFactory = Objects.requireNonNull(mainRunnableFactory);
        this.shutdownRunnableFactory = Objects.requireNonNull(shutdownRunnableFactory);
        this.thread = threadFactory.newThread(this::run);
        this.thread.start();
    }

    public static ShutdownableThread start(RunnableFactory mainRunnableFactory, RunnableFactory shutdownRunnableFactory, ThreadFactory threadFactory) {
        return new ShutdownableThread(mainRunnableFactory, shutdownRunnableFactory, threadFactory);
    }

    private void run() {
        Runnable main = this.mainRunnableFactory.create(this::keepMainRunning);
        Runnable shutdown = this.shutdownRunnableFactory.create(this::keepShutdownRunning);
        main.run();
        shutdown.run();
    }

    @Override
    public void shutdown() {
        this.state.compareAndSet(0, 1);
    }

    @Override
    public List<Runnable> shutdownNow() {
        int shutdownAndNow = 3;
        if (!this.state.compareAndSet(0, 3)) {
            this.state.compareAndSet(1, 3);
        }
        return Collections.emptyList();
    }

    private boolean keepMainRunning() {
        return (this.state.get() & 1) == 0;
    }

    private boolean keepShutdownRunning() {
        return (this.state.get() & 2) == 0;
    }

    @Override
    public boolean isShutdown() {
        return (this.state.get() & 1) != 0;
    }

    @Override
    public boolean isTerminated() {
        return this.threadState() == Thread.State.TERMINATED;
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) {
        if (timeout < 0L) {
            throw new IllegalArgumentException("timeout value is negative: " + timeout);
        }
        if (this.isTerminated()) {
            return true;
        }
        long millis = unit.toMillis(timeout);
        long nanos = unit.toNanos(timeout - unit.convert(millis, TimeUnit.MILLISECONDS));
        try {
            if (nanos == 0L) {
                this.thread.join(millis);
            } else {
                this.thread.join(millis, (int)nanos);
            }
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Join interrupted for thread " + this.thread);
        }
        return this.isTerminated();
    }

    @Override
    public Thread.State threadState() {
        return this.thread.getState();
    }

    @Override
    public void stop() {
        this.shutdown();
    }

    @Override
    public void join(long millis) {
        this.awaitTermination(millis, TimeUnit.MILLISECONDS);
    }

    public String toString() {
        return this.thread.getName();
    }
}

