/*
 * Decompiled with CFR 0.152.
 */
package org.tools4j.nobark.queue;

import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.tools4j.nobark.queue.ConflationQueue;

public interface ExchangeConflationQueue<K, V>
extends ConflationQueue<K, V> {
    @Override
    public ConflationQueue.Appender<K, V> appender();

    @Override
    public ExchangePoller<K, V> poller();

    public static <K, V> ExchangeConflationQueue<K, V> nullSafe(final ExchangeConflationQueue<K, V> unsafeQueue, final Function<? super K, ? extends V> valueFactory) {
        Objects.requireNonNull(unsafeQueue);
        Objects.requireNonNull(valueFactory);
        return new ExchangeConflationQueue<K, V>(){
            final ThreadLocal<ConflationQueue.Appender<K, V>> appender = ThreadLocal.withInitial(() -> ExchangeConflationQueue.nullSafe(unsafeQueue.appender(), valueFactory));

            @Override
            public ConflationQueue.Appender<K, V> appender() {
                return this.appender.get();
            }

            @Override
            public ExchangePoller<K, V> poller() {
                return unsafeQueue.poller();
            }

            @Override
            public int size() {
                return unsafeQueue.size();
            }
        };
    }

    public static <K, V> ConflationQueue.Appender<K, V> nullSafe(ConflationQueue.Appender<K, V> unsafeAppender, Function<? super K, ? extends V> valueFactory) {
        Objects.requireNonNull(unsafeAppender);
        Objects.requireNonNull(valueFactory);
        return (k, v) -> {
            Object value = unsafeAppender.enqueue(k, v);
            return value == null ? Objects.requireNonNull(valueFactory.apply((Object)k), "value factory returned null") : value;
        };
    }

    @FunctionalInterface
    public static interface ExchangePoller<K, V>
    extends ConflationQueue.Poller<K, V> {
        public V poll(BiConsumer<? super K, ? super V> var1, V var2);

        default public V poll(V exchange) {
            return (V)this.poll((k, v) -> {}, exchange);
        }

        @Override
        default public V poll(BiConsumer<? super K, ? super V> consumer) {
            return this.poll(consumer, null);
        }
    }
}

