/*
 * Decompiled with CFR 0.152.
 */
package org.tools4j.nobark.queue;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.function.Supplier;
import org.tools4j.nobark.queue.AppenderListener;
import org.tools4j.nobark.queue.AtomicConflationQueue;
import org.tools4j.nobark.queue.ConflationQueue;
import org.tools4j.nobark.queue.ConflationQueueBuilder;
import org.tools4j.nobark.queue.EvictConflationQueue;
import org.tools4j.nobark.queue.ExchangeConflationQueue;
import org.tools4j.nobark.queue.MergeConflationQueue;
import org.tools4j.nobark.queue.Merger;
import org.tools4j.nobark.queue.PollerListener;

class ConflationQueueBuilderImpl<K, V>
implements ConflationQueueBuilder<K, V> {
    private final CqFactory<K, V> cqFactory;
    private Supplier<? extends AppenderListener<? super K, ? super V>> appenderListenerSupplier = () -> AppenderListener.NOOP;
    private Supplier<? extends PollerListener<? super K, ? super V>> pollerListenerSupplier = () -> PollerListener.NOOP;

    private ConflationQueueBuilderImpl(CqFactory<K, V> cqFactory) {
        this.cqFactory = Objects.requireNonNull(cqFactory);
    }

    @Override
    public ConflationQueueBuilder<K, V> withAppenderListener(Supplier<? extends AppenderListener<? super K, ? super V>> listenerSupplier) {
        this.appenderListenerSupplier = Objects.requireNonNull(listenerSupplier);
        return this;
    }

    @Override
    public ConflationQueueBuilder<K, V> withPollerListener(Supplier<? extends PollerListener<? super K, ? super V>> listenerSupplier) {
        this.pollerListenerSupplier = Objects.requireNonNull(listenerSupplier);
        return this;
    }

    @Override
    public ConflationQueueBuilder.ExchangeConflationQueueBuilder<K, V> withExchangeValueSupport() {
        return new EvictConflationQueueBuilder();
    }

    @Override
    public ConflationQueueBuilder.ExchangeConflationQueueBuilder<K, V> withMerging(Merger<? super K, V> merger) {
        return new MergeConflationQueueBuilder(merger);
    }

    @Override
    public ConflationQueue<K, V> build(Supplier<? extends Queue<Object>> queueFactory) {
        return this.cqFactory.atomicQueue(queueFactory, this.appenderListenerSupplier, this.pollerListenerSupplier);
    }

    class MergeConflationQueueBuilder
    implements ConflationQueueBuilder.ExchangeConflationQueueBuilder<K, V> {
        private final Merger<? super K, V> merger;

        MergeConflationQueueBuilder(Merger<? super K, V> merger) {
            this.merger = Objects.requireNonNull(merger);
        }

        public MergeConflationQueueBuilder withAppenderListener(Supplier<? extends AppenderListener<? super K, ? super V>> listenerSupplier) {
            ConflationQueueBuilderImpl.this.withAppenderListener(listenerSupplier);
            return this;
        }

        public MergeConflationQueueBuilder withPollerListener(Supplier<? extends PollerListener<? super K, ? super V>> listenerSupplier) {
            ConflationQueueBuilderImpl.this.withPollerListener(listenerSupplier);
            return this;
        }

        @Override
        public MergeConflationQueue<K, V> build(Supplier<? extends Queue<Object>> queueFactory) {
            return ConflationQueueBuilderImpl.this.cqFactory.mergeQueue(queueFactory, this.merger, ConflationQueueBuilderImpl.this.appenderListenerSupplier, ConflationQueueBuilderImpl.this.pollerListenerSupplier);
        }
    }

    class EvictConflationQueueBuilder
    implements ConflationQueueBuilder.ExchangeConflationQueueBuilder<K, V> {
        EvictConflationQueueBuilder() {
        }

        public EvictConflationQueueBuilder withAppenderListener(Supplier<? extends AppenderListener<? super K, ? super V>> listenerSupplier) {
            ConflationQueueBuilderImpl.this.withAppenderListener(listenerSupplier);
            return this;
        }

        public EvictConflationQueueBuilder withPollerListener(Supplier<? extends PollerListener<? super K, ? super V>> listenerSupplier) {
            ConflationQueueBuilderImpl.this.withPollerListener(listenerSupplier);
            return this;
        }

        @Override
        public ExchangeConflationQueue<K, V> build(Supplier<? extends Queue<Object>> queueFactory) {
            return ConflationQueueBuilderImpl.this.cqFactory.evictQueue(queueFactory, ConflationQueueBuilderImpl.this.appenderListenerSupplier, ConflationQueueBuilderImpl.this.pollerListenerSupplier);
        }
    }

    static class DeclaredKeysBuilder<K, V>
    extends ConflationQueueBuilderImpl<K, V> {
        DeclaredKeysBuilder(final List<? extends K> allConflationKeys) {
            super(new CqFactory<K, V>(){

                @Override
                public AtomicConflationQueue<K, V> atomicQueue(Supplier<? extends Queue<Object>> queueFactory, Supplier<? extends AppenderListener<? super K, ? super V>> appenderListenerSupplier, Supplier<? extends PollerListener<? super K, ? super V>> pollerListenerSupplier) {
                    return new AtomicConflationQueue(queueFactory, allConflationKeys, appenderListenerSupplier.get(), pollerListenerSupplier.get());
                }

                @Override
                public EvictConflationQueue<K, V> evictQueue(Supplier<? extends Queue<Object>> queueFactory, Supplier<? extends AppenderListener<? super K, ? super V>> appenderListenerSupplier, Supplier<? extends PollerListener<? super K, ? super V>> pollerListenerSupplier) {
                    return new EvictConflationQueue(queueFactory, allConflationKeys, appenderListenerSupplier, pollerListenerSupplier);
                }

                @Override
                public MergeConflationQueue<K, V> mergeQueue(Supplier<? extends Queue<Object>> queueFactory, Merger<? super K, V> merger, Supplier<? extends AppenderListener<? super K, ? super V>> appenderListenerSupplier, Supplier<? extends PollerListener<? super K, ? super V>> pollerListenerSupplier) {
                    return new MergeConflationQueue(queueFactory, merger, allConflationKeys, appenderListenerSupplier, pollerListenerSupplier);
                }
            });
        }
    }

    static class EnumKeyBuilder<K extends Enum<K>, V>
    extends ConflationQueueBuilderImpl<K, V> {
        EnumKeyBuilder(final Class<K> enumConflationKeyClass) {
            super(new CqFactory<K, V>(){

                @Override
                public AtomicConflationQueue<K, V> atomicQueue(Supplier<? extends Queue<Object>> queueFactory, Supplier<? extends AppenderListener<? super K, ? super V>> appenderListenerSupplier, Supplier<? extends PollerListener<? super K, ? super V>> pollerListenerSupplier) {
                    return AtomicConflationQueue.forEnumConflationKey(queueFactory, enumConflationKeyClass, appenderListenerSupplier.get(), pollerListenerSupplier.get());
                }

                @Override
                public EvictConflationQueue<K, V> evictQueue(Supplier<? extends Queue<Object>> queueFactory, Supplier<? extends AppenderListener<? super K, ? super V>> appenderListenerSupplier, Supplier<? extends PollerListener<? super K, ? super V>> pollerListenerSupplier) {
                    return EvictConflationQueue.forEnumConflationKey(queueFactory, enumConflationKeyClass, appenderListenerSupplier, pollerListenerSupplier);
                }

                @Override
                public MergeConflationQueue<K, V> mergeQueue(Supplier<? extends Queue<Object>> queueFactory, Merger<? super K, V> merger, Supplier<? extends AppenderListener<? super K, ? super V>> appenderListenerSupplier, Supplier<? extends PollerListener<? super K, ? super V>> pollerListenerSupplier) {
                    return MergeConflationQueue.forEnumConflationKey(queueFactory, merger, enumConflationKeyClass, appenderListenerSupplier, pollerListenerSupplier);
                }
            });
        }
    }

    static class EntryMapFactoryBuilder<K, V>
    extends ConflationQueueBuilderImpl<K, V> {
        EntryMapFactoryBuilder(final Supplier<? extends Map<Object, Object>> entryMapFactory) {
            super(new CqFactory<K, V>(){

                @Override
                public AtomicConflationQueue<K, V> atomicQueue(Supplier<? extends Queue<Object>> queueFactory, Supplier<? extends AppenderListener<? super K, ? super V>> appenderListenerSupplier, Supplier<? extends PollerListener<? super K, ? super V>> pollerListenerSupplier) {
                    return new AtomicConflationQueue(queueFactory, entryMapFactory, appenderListenerSupplier.get(), pollerListenerSupplier.get());
                }

                @Override
                public EvictConflationQueue<K, V> evictQueue(Supplier<? extends Queue<Object>> queueFactory, Supplier<? extends AppenderListener<? super K, ? super V>> appenderListenerSupplier, Supplier<? extends PollerListener<? super K, ? super V>> pollerListenerSupplier) {
                    return new EvictConflationQueue(queueFactory, entryMapFactory, appenderListenerSupplier, pollerListenerSupplier);
                }

                @Override
                public MergeConflationQueue<K, V> mergeQueue(Supplier<? extends Queue<Object>> queueFactory, Merger<? super K, V> merger, Supplier<? extends AppenderListener<? super K, ? super V>> appenderListenerSupplier, Supplier<? extends PollerListener<? super K, ? super V>> pollerListenerSupplier) {
                    return new MergeConflationQueue(queueFactory, entryMapFactory, merger, appenderListenerSupplier, pollerListenerSupplier);
                }
            });
        }
    }

    static class DefaultBuilder<K, V>
    extends ConflationQueueBuilderImpl<K, V> {
        DefaultBuilder() {
            super(new CqFactory<K, V>(){

                @Override
                public AtomicConflationQueue<K, V> atomicQueue(Supplier<? extends Queue<Object>> queueFactory, Supplier<? extends AppenderListener<? super K, ? super V>> appenderListenerSupplier, Supplier<? extends PollerListener<? super K, ? super V>> pollerListenerSupplier) {
                    return new AtomicConflationQueue(queueFactory, appenderListenerSupplier.get(), pollerListenerSupplier.get());
                }

                @Override
                public EvictConflationQueue<K, V> evictQueue(Supplier<? extends Queue<Object>> queueFactory, Supplier<? extends AppenderListener<? super K, ? super V>> appenderListenerSupplier, Supplier<? extends PollerListener<? super K, ? super V>> pollerListenerSupplier) {
                    return new EvictConflationQueue(queueFactory, appenderListenerSupplier, pollerListenerSupplier);
                }

                @Override
                public MergeConflationQueue<K, V> mergeQueue(Supplier<? extends Queue<Object>> queueFactory, Merger<? super K, V> merger, Supplier<? extends AppenderListener<? super K, ? super V>> appenderListenerSupplier, Supplier<? extends PollerListener<? super K, ? super V>> pollerListenerSupplier) {
                    return new MergeConflationQueue(queueFactory, merger, appenderListenerSupplier, pollerListenerSupplier);
                }
            });
        }
    }

    static interface CqFactory<K, V> {
        public AtomicConflationQueue<K, V> atomicQueue(Supplier<? extends Queue<Object>> var1, Supplier<? extends AppenderListener<? super K, ? super V>> var2, Supplier<? extends PollerListener<? super K, ? super V>> var3);

        public EvictConflationQueue<K, V> evictQueue(Supplier<? extends Queue<Object>> var1, Supplier<? extends AppenderListener<? super K, ? super V>> var2, Supplier<? extends PollerListener<? super K, ? super V>> var3);

        public MergeConflationQueue<K, V> mergeQueue(Supplier<? extends Queue<Object>> var1, Merger<? super K, V> var2, Supplier<? extends AppenderListener<? super K, ? super V>> var3, Supplier<? extends PollerListener<? super K, ? super V>> var4);
    }
}

