/*
 * Decompiled with CFR 0.152.
 */
package org.tools4j.nobark.loop;

import java.util.Objects;
import org.tools4j.nobark.loop.Step;

@FunctionalInterface
public interface ComposableStep
extends Step {
    public static final ComposableStep NO_OP = new ComposableStep(){

        @Override
        public boolean perform() {
            return false;
        }

        @Override
        public ComposableStep then(Step next) {
            return ComposableStep.create(next);
        }

        @Override
        public ComposableStep thenIfPerformed(Step next) {
            Objects.requireNonNull(next);
            return NO_OP;
        }

        @Override
        public ComposableStep thenIfNotPerformed(Step next) {
            return ComposableStep.create(next);
        }
    };

    default public ComposableStep then(Step next) {
        Objects.requireNonNull(next);
        return next == NO_OP ? this : () -> this.perform() | next.perform();
    }

    default public ComposableStep thenIfPerformed(Step next) {
        Objects.requireNonNull(next);
        return next == NO_OP ? this : () -> this.perform() && true | next.perform();
    }

    default public ComposableStep thenIfNotPerformed(Step next) {
        Objects.requireNonNull(next);
        return next == NO_OP ? this : () -> this.perform() || next.perform();
    }

    public static ComposableStep create(Step step) {
        Objects.requireNonNull(step);
        return step == NO_OP ? NO_OP : (step instanceof ComposableStep ? (ComposableStep)step : step::perform);
    }

    public static ComposableStep composite(Step ... components) {
        Objects.requireNonNull(components);
        ComposableStep result = NO_OP;
        for (Step component : components) {
            result = result.then(component);
        }
        return result;
    }
}

