/*
 * Decompiled with CFR 0.152.
 */
package org.tools4j.nobark.queue;

import java.util.function.Supplier;
import org.tools4j.nobark.queue.ConflationQueue;

@FunctionalInterface
public interface PollerListener<K, V> {
    public static final PollerListener<Object, Object> NOOP = (q, k, v) -> {};

    public void polled(ConflationQueue<? extends K, ? extends V> var1, K var2, V var3);

    default public void polledButFoundEmpty(ConflationQueue<? extends K, ? extends V> queue) {
        this.polled(queue, null, null);
    }

    public static <K, V> PollerListener<K, V> threadLocal(Supplier<? extends PollerListener<K, V>> listenerSupplier) {
        ThreadLocal threadLocal = ThreadLocal.withInitial(listenerSupplier);
        return (q, k, v) -> ((PollerListener)threadLocal.get()).polled(q, k, v);
    }

    public static <L extends PollerListener<?, ?>> Supplier<L> threadLocalSupplier(Supplier<L> listenerSupplier) {
        return ThreadLocal.withInitial(listenerSupplier)::get;
    }
}

