/*
 * Decompiled with CFR 0.152.
 */
package org.tools4j.nobark.queue;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.tools4j.nobark.queue.AppenderListener;
import org.tools4j.nobark.queue.ConflationQueue;
import org.tools4j.nobark.queue.Entry;
import org.tools4j.nobark.queue.ExchangeConflationQueue;
import org.tools4j.nobark.queue.Factories;
import org.tools4j.nobark.queue.PollerListener;
import sun.misc.Contended;

public class EvictConflationQueue<K, V>
implements ExchangeConflationQueue<K, V> {
    private final Queue<Entry<K, MarkedValue<V>>> queue;
    private final Map<K, Entry<K, MarkedValue<V>>> entryMap;
    private final ThreadLocal<ConflationQueue.Appender<K, V>> appender = ThreadLocal.withInitial(() -> new EvictQueueAppender());
    private final ThreadLocal<ExchangeConflationQueue.ExchangePoller<K, V>> poller = ThreadLocal.withInitial(() -> new EvictQueuePoller());
    private final Supplier<? extends AppenderListener<? super K, ? super V>> appenderListenerSupplier;
    private final Supplier<? extends PollerListener<? super K, ? super V>> pollerListenerSupplier;

    private EvictConflationQueue(Queue<Entry<K, MarkedValue<V>>> queue, Map<K, Entry<K, MarkedValue<V>>> entryMap, Supplier<? extends AppenderListener<? super K, ? super V>> appenderListenerSupplier, Supplier<? extends PollerListener<? super K, ? super V>> pollerListenerSupplier) {
        this.queue = Objects.requireNonNull(queue);
        this.entryMap = Objects.requireNonNull(entryMap);
        this.appenderListenerSupplier = Objects.requireNonNull(appenderListenerSupplier);
        this.pollerListenerSupplier = Objects.requireNonNull(pollerListenerSupplier);
    }

    public EvictConflationQueue(Supplier<? extends Queue<Object>> queueFactory) {
        this(queueFactory, () -> AppenderListener.NOOP, () -> PollerListener.NOOP);
    }

    public EvictConflationQueue(Supplier<? extends Queue<Object>> queueFactory, Supplier<? extends AppenderListener<? super K, ? super V>> appenderListenerSupplier, Supplier<? extends PollerListener<? super K, ? super V>> pollerListenerSupplier) {
        this(queueFactory, ConcurrentHashMap::new, appenderListenerSupplier, pollerListenerSupplier);
    }

    public EvictConflationQueue(Supplier<? extends Queue<Object>> queueFactory, Supplier<? extends Map<Object, Object>> entryMapFactory, Supplier<? extends AppenderListener<? super K, ? super V>> appenderListenerSupplier, Supplier<? extends PollerListener<? super K, ? super V>> pollerListenerSupplier) {
        this(Factories.createQueue(queueFactory), Factories.createMap(entryMapFactory), appenderListenerSupplier, pollerListenerSupplier);
    }

    public EvictConflationQueue(Supplier<? extends Queue<Object>> queueFactory, List<? extends K> allConflationKeys) {
        this(queueFactory, allConflationKeys, () -> AppenderListener.NOOP, () -> PollerListener.NOOP);
    }

    public EvictConflationQueue(Supplier<? extends Queue<Object>> queueFactory, List<? extends K> allConflationKeys, Supplier<? extends AppenderListener<? super K, ? super V>> appenderListenerSupplier, Supplier<? extends PollerListener<? super K, ? super V>> pollerListenerSupplier) {
        this(Factories.createQueue(queueFactory), Entry.eagerlyInitialiseEntryMap(allConflationKeys, () -> new MarkedValue()), appenderListenerSupplier, pollerListenerSupplier);
    }

    public static <K extends Enum<K>, V> EvictConflationQueue<K, V> forEnumConflationKey(Supplier<? extends Queue<Object>> queueFactory, Class<K> conflationKeyClass) {
        return EvictConflationQueue.forEnumConflationKey(queueFactory, conflationKeyClass, () -> AppenderListener.NOOP, () -> PollerListener.NOOP);
    }

    public static <K extends Enum<K>, V> EvictConflationQueue<K, V> forEnumConflationKey(Supplier<? extends Queue<Object>> queueFactory, Class<K> conflationKeyClass, Supplier<? extends AppenderListener<? super K, ? super V>> appenderListenerSupplier, Supplier<? extends PollerListener<? super K, ? super V>> pollerListenerSupplier) {
        return new EvictConflationQueue<K, V>(Factories.createQueue(queueFactory), Entry.eagerlyInitialiseEntryEnumMap(conflationKeyClass, () -> new MarkedValue()), appenderListenerSupplier, pollerListenerSupplier);
    }

    @Override
    public ConflationQueue.Appender<K, V> appender() {
        return this.appender.get();
    }

    @Override
    public ExchangeConflationQueue.ExchangePoller<K, V> poller() {
        return this.poller.get();
    }

    @Override
    public int size() {
        return this.queue.size();
    }

    private final class EvictQueuePoller
    implements ExchangeConflationQueue.ExchangePoller<K, V> {
        final PollerListener<? super K, ? super V> pollerListener;
        @Contended
        MarkedValue<V> markedValue;

        private EvictQueuePoller() {
            this.pollerListener = (PollerListener)EvictConflationQueue.this.pollerListenerSupplier.get();
            this.markedValue = new MarkedValue();
        }

        @Override
        public V poll(BiConsumer<? super K, ? super V> consumer, V exchange) {
            Entry entry = (Entry)EvictConflationQueue.this.queue.poll();
            if (entry != null) {
                MarkedValue exchangeValue = this.markedValue.initalizeWithUnused(exchange);
                MarkedValue polledValue = entry.value.getAndSet(exchangeValue);
                Object value = polledValue.markUnusedAndRelease();
                this.markedValue = polledValue;
                consumer.accept(entry.key, value);
                this.pollerListener.polled(EvictConflationQueue.this, entry.key, value);
                return value;
            }
            this.pollerListener.polledButFoundEmpty(EvictConflationQueue.this);
            return null;
        }
    }

    private final class EvictQueueAppender
    implements ConflationQueue.Appender<K, V> {
        final AppenderListener<? super K, ? super V> appenderListener;
        @Contended
        MarkedValue<V> markedValue;

        private EvictQueueAppender() {
            this.appenderListener = (AppenderListener)EvictConflationQueue.this.appenderListenerSupplier.get();
            this.markedValue = new MarkedValue();
        }

        @Override
        public V enqueue(K conflationKey, V value) {
            AppenderListener.Conflation conflation;
            Objects.requireNonNull(value);
            Entry entry = EvictConflationQueue.this.entryMap.computeIfAbsent(conflationKey, k -> new Entry(k, new MarkedValue()));
            MarkedValue newValue = this.markedValue.initializeWithUsed(value);
            MarkedValue oldValue = entry.value.getAndSet(newValue);
            if (oldValue.isUnused()) {
                EvictConflationQueue.this.queue.add(entry);
                conflation = AppenderListener.Conflation.UNCONFLATED;
            } else {
                conflation = AppenderListener.Conflation.EVICTED;
            }
            this.markedValue = oldValue;
            Object old = oldValue.markUnusedAndRelease();
            this.appenderListener.enqueued(EvictConflationQueue.this, conflationKey, value, old, conflation);
            return old;
        }
    }

    @Contended
    private static final class MarkedValue<V> {
        V value;
        State state = State.UNUSED;

        private MarkedValue() {
        }

        MarkedValue<V> initializeWithUsed(V value) {
            this.value = Objects.requireNonNull(value);
            this.state = State.USED;
            return this;
        }

        MarkedValue<V> initalizeWithUnused(V value) {
            this.value = value;
            this.state = State.UNUSED;
            return this;
        }

        V markUnusedAndRelease() {
            V released = this.value;
            this.state = State.UNUSED;
            this.value = null;
            return released;
        }

        boolean isUnused() {
            return this.state == State.UNUSED;
        }

        static enum State {
            USED,
            UNUSED;

        }
    }
}

