/*
 * Decompiled with CFR 0.152.
 */
package org.tools4j.nobark.queue;

import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;

final class Entry<K, V> {
    final K key;
    final AtomicReference<V> value;

    Entry(K key, V value) {
        this.key = Objects.requireNonNull(key);
        this.value = new AtomicReference<V>(value);
    }

    static <K, V> Map<K, Entry<K, V>> eagerlyInitialiseEntryMap(List<? extends K> allKeys, Supplier<V> valueFactory) {
        HashMap<K, Entry<K, V>> entryMap = new HashMap<K, Entry<K, V>>((int)Math.ceil((double)allKeys.size() / 0.75));
        for (int i = 0; i < allKeys.size(); ++i) {
            K key = allKeys.get(i);
            entryMap.put(key, new Entry<K, V>(key, valueFactory.get()));
        }
        return entryMap;
    }

    static <K extends Enum<K>, V> Map<K, Entry<K, V>> eagerlyInitialiseEntryEnumMap(Class<K> keyClass, Supplier<V> valueFactory) {
        EnumMap<Enum, Entry<Enum, V>> entryMap = new EnumMap<Enum, Entry<Enum, V>>(keyClass);
        for (Enum key : (Enum[])keyClass.getEnumConstants()) {
            entryMap.put(key, new Entry<Enum, V>(key, valueFactory.get()));
        }
        return entryMap;
    }
}

