/*
 * Decompiled with CFR 0.152.
 */
package org.tools4j.nobark.queue;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.tools4j.nobark.queue.AppenderListener;
import org.tools4j.nobark.queue.ConflationQueue;
import org.tools4j.nobark.queue.Entry;
import org.tools4j.nobark.queue.Factories;
import org.tools4j.nobark.queue.PollerListener;

public class AtomicConflationQueue<K, V>
implements ConflationQueue<K, V> {
    private final Queue<Entry<K, V>> queue;
    private final Map<K, Entry<K, V>> entryMap;
    private final ConflationQueue.Appender<K, V> appender = new AtomicQueueAppender();
    private final ConflationQueue.Poller<K, V> poller = new AtomicQueuePoller();
    private final AppenderListener<? super K, ? super V> appenderListener;
    private final PollerListener<? super K, ? super V> pollerListener;

    private AtomicConflationQueue(Queue<Entry<K, V>> queue, Map<K, Entry<K, V>> entryMap, AppenderListener<? super K, ? super V> appenderListener, PollerListener<? super K, ? super V> pollerListener) {
        this.queue = Objects.requireNonNull(queue);
        this.entryMap = Objects.requireNonNull(entryMap);
        this.appenderListener = Objects.requireNonNull(appenderListener);
        this.pollerListener = Objects.requireNonNull(pollerListener);
    }

    public AtomicConflationQueue(Supplier<? extends Queue<Object>> queueFactory) {
        this(queueFactory, AppenderListener.NOOP, PollerListener.NOOP);
    }

    public AtomicConflationQueue(Supplier<? extends Queue<Object>> queueFactory, AppenderListener<? super K, ? super V> appenderListener, PollerListener<? super K, ? super V> pollerListener) {
        this(queueFactory, ConcurrentHashMap::new, appenderListener, pollerListener);
    }

    public AtomicConflationQueue(Supplier<? extends Queue<Object>> queueFactory, Supplier<? extends Map<Object, Object>> entryMapFactory, AppenderListener<? super K, ? super V> appenderListener, PollerListener<? super K, ? super V> pollerListener) {
        this(Factories.createQueue(queueFactory), Factories.createMap(entryMapFactory), appenderListener, pollerListener);
    }

    public AtomicConflationQueue(Supplier<? extends Queue<Object>> queueFactory, List<? extends K> allConflationKeys) {
        this(queueFactory, allConflationKeys, AppenderListener.NOOP, PollerListener.NOOP);
    }

    public AtomicConflationQueue(Supplier<? extends Queue<Object>> queueFactory, List<? extends K> allConflationKeys, AppenderListener<? super K, ? super V> appenderListener, PollerListener<? super K, ? super V> pollerListener) {
        this(Factories.createQueue(queueFactory), Entry.eagerlyInitialiseEntryMap(allConflationKeys, () -> null), appenderListener, pollerListener);
    }

    public static <K extends Enum<K>, V> AtomicConflationQueue<K, V> forEnumConflationKey(Supplier<? extends Queue<Object>> queueFactory, Class<K> conflationKeyClass) {
        return AtomicConflationQueue.forEnumConflationKey(queueFactory, conflationKeyClass, AppenderListener.NOOP, PollerListener.NOOP);
    }

    public static <K extends Enum<K>, V> AtomicConflationQueue<K, V> forEnumConflationKey(Supplier<? extends Queue<Object>> queueFactory, Class<K> conflationKeyClass, AppenderListener<? super K, ? super V> appenderListener, PollerListener<? super K, ? super V> pollerListener) {
        return new AtomicConflationQueue<K, V>(Factories.createQueue(queueFactory), Entry.eagerlyInitialiseEntryEnumMap(conflationKeyClass, () -> null), appenderListener, pollerListener);
    }

    @Override
    public ConflationQueue.Appender<K, V> appender() {
        return this.appender;
    }

    @Override
    public ConflationQueue.Poller<K, V> poller() {
        return this.poller;
    }

    @Override
    public int size() {
        return this.queue.size();
    }

    private final class AtomicQueuePoller
    implements ConflationQueue.Poller<K, V> {
        private AtomicQueuePoller() {
        }

        @Override
        public V poll(BiConsumer<? super K, ? super V> consumer) {
            Entry entry = (Entry)AtomicConflationQueue.this.queue.poll();
            if (entry != null) {
                Object value = entry.value.getAndSet(null);
                consumer.accept(entry.key, value);
                AtomicConflationQueue.this.pollerListener.polled(AtomicConflationQueue.this, entry.key, value);
                return value;
            }
            AtomicConflationQueue.this.pollerListener.polledButFoundEmpty(AtomicConflationQueue.this);
            return null;
        }
    }

    private final class AtomicQueueAppender
    implements ConflationQueue.Appender<K, V> {
        private AtomicQueueAppender() {
        }

        @Override
        public V enqueue(K conflationKey, V value) {
            AppenderListener.Conflation conflation;
            Objects.requireNonNull(value);
            Entry entry = AtomicConflationQueue.this.entryMap.computeIfAbsent(conflationKey, k -> new Entry<Object, Object>(k, null));
            Object old = entry.value.getAndSet(value);
            if (old == null) {
                AtomicConflationQueue.this.queue.add(entry);
                conflation = AppenderListener.Conflation.UNCONFLATED;
            } else {
                conflation = AppenderListener.Conflation.EVICTED;
            }
            AtomicConflationQueue.this.appenderListener.enqueued(AtomicConflationQueue.this, conflationKey, value, old, conflation);
            return old;
        }
    }
}

