/*
 * Decompiled with CFR 0.152.
 */
package org.tools4j.nobark.loop;

import java.util.Objects;
import java.util.concurrent.ThreadFactory;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import org.tools4j.nobark.loop.Stoppable;
import sun.misc.Contended;

public class StoppableThread
implements Stoppable {
    private final Function<BooleanSupplier, Runnable> runnableFactory;
    private final Thread thread;
    @Contended
    private volatile boolean running;

    protected StoppableThread(Function<BooleanSupplier, Runnable> runnableFactory, ThreadFactory threadFactory) {
        this.thread = threadFactory.newThread(this::run);
        this.runnableFactory = Objects.requireNonNull(runnableFactory);
        this.running = true;
        this.thread.start();
    }

    public static StoppableThread start(Function<BooleanSupplier, Runnable> runnableFactory, ThreadFactory threadFactory) {
        return new StoppableThread(runnableFactory, threadFactory);
    }

    private void run() {
        Runnable runnable = this.runnableFactory.apply(this::isRunning);
        runnable.run();
    }

    public boolean isRunning() {
        return this.running;
    }

    @Override
    public void stop() {
        this.running = false;
    }

    public void join() {
        this.join(0L);
    }

    public void join(long millis) {
        try {
            this.thread.join(millis);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("join was interrupted for thread=" + this.thread);
        }
    }

    public String toString() {
        return this.thread.getName();
    }
}

