/*
 * Decompiled with CFR 0.152.
 */
package org.tools4j.nobark.loop;

import java.util.Objects;
import org.tools4j.nobark.loop.Step;

@FunctionalInterface
public interface StepProvider {
    public Step provide(boolean var1);

    public static Step normalStep(StepProvider supplier) {
        return supplier.provide(false);
    }

    public static Step shutdownStep(StepProvider supplier) {
        return supplier.provide(true);
    }

    public static StepProvider alwaysProvide(Step step) {
        Objects.requireNonNull(step);
        return forShutdown -> step;
    }

    public static StepProvider silenceDuringShutdown(Step step) {
        Objects.requireNonNull(step);
        return forShutdown -> forShutdown ? Step.NO_OP : step;
    }
}

