/*
 * Decompiled with CFR 0.152.
 */
package org.tools4j.nobark.loop;

import java.util.Objects;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import org.tools4j.nobark.loop.Shutdownable;
import sun.misc.Contended;

public class ShutdownableThread
implements Shutdownable {
    private static final int RUNNING = 0;
    private static final int SHUTDOWN = 1;
    private static final int SHUTDOWN_NOW = 2;
    private static final int TERMINATED = 4;
    private final Function<BooleanSupplier, Runnable> mainRunnableFactory;
    private final Function<BooleanSupplier, Runnable> shutdownRunnableFactory;
    private final Thread thread;
    @Contended
    private final AtomicInteger state = new AtomicInteger(0);

    protected ShutdownableThread(Function<BooleanSupplier, Runnable> mainRunnableFactory, Function<BooleanSupplier, Runnable> shutdownRunnableFactory, ThreadFactory threadFactory) {
        this.mainRunnableFactory = Objects.requireNonNull(mainRunnableFactory);
        this.shutdownRunnableFactory = Objects.requireNonNull(shutdownRunnableFactory);
        this.thread = threadFactory.newThread(this::run);
        this.thread.start();
    }

    public static ShutdownableThread start(Function<BooleanSupplier, Runnable> mainRunnableFactory, Function<BooleanSupplier, Runnable> shutdownRunnableFactory, ThreadFactory threadFactory) {
        return new ShutdownableThread(mainRunnableFactory, shutdownRunnableFactory, threadFactory);
    }

    private void run() {
        Runnable main = this.mainRunnableFactory.apply(this::isRunning);
        Runnable shutdown = this.shutdownRunnableFactory.apply(this::isShutdownRunning);
        main.run();
        shutdown.run();
        this.notifyTerminated();
    }

    @Override
    public void shutdown() {
        this.state.compareAndSet(0, 1);
    }

    @Override
    public void shutdownNow() {
        int shutdownAndNow = 3;
        if (!this.state.compareAndSet(0, 3)) {
            this.state.compareAndSet(1, 3);
        }
    }

    private void notifyTerminated() {
        if (!this.state.compareAndSet(1, 5)) {
            this.state.compareAndSet(3, 7);
        }
    }

    private boolean isRunning() {
        return (this.state.get() & 1) == 0;
    }

    private boolean isShutdownRunning() {
        return (this.state.get() & 2) == 0;
    }

    @Override
    public boolean isShutdown() {
        return (this.state.get() & 1) != 0;
    }

    @Override
    public boolean isTerminated() {
        return (this.state.get() & 4) != 0;
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) {
        if (timeout < 0L) {
            throw new IllegalArgumentException("timeout value is negative: " + timeout);
        }
        if (this.isTerminated()) {
            return true;
        }
        if (timeout == 0L) {
            return this.isTerminated();
        }
        long millis = unit.toMillis(timeout);
        long nanos = unit.toNanos(timeout - unit.convert(millis, TimeUnit.MILLISECONDS));
        try {
            if (nanos == 0L) {
                this.thread.join(millis);
            } else {
                this.thread.join(millis, (int)nanos);
            }
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Join interrupted for thread " + this.thread);
        }
        return this.isTerminated();
    }

    public String toString() {
        return this.thread.getName();
    }
}

