/*
 * Decompiled with CFR 0.152.
 */
package org.tools4j.nobark.loop;

import java.util.Objects;
import java.util.concurrent.ThreadFactory;
import java.util.function.Function;
import org.tools4j.nobark.loop.ExceptionHandler;
import org.tools4j.nobark.loop.IdleStrategy;
import org.tools4j.nobark.loop.LoopCondition;
import org.tools4j.nobark.loop.ShutdownableThread;
import org.tools4j.nobark.loop.Step;
import org.tools4j.nobark.loop.StepProvider;
import org.tools4j.nobark.loop.StoppableThread;

public class Loop
implements Runnable {
    private final LoopCondition loopCondition;
    private final IdleStrategy idleStrategy;
    private final ExceptionHandler exceptionHandler;
    private final Step[] steps;

    public Loop(LoopCondition loopCondition, IdleStrategy idleStrategy, ExceptionHandler exceptionHandler, Step ... steps) {
        this.loopCondition = Objects.requireNonNull(loopCondition);
        this.idleStrategy = Objects.requireNonNull(idleStrategy);
        this.exceptionHandler = Objects.requireNonNull(exceptionHandler);
        this.steps = Objects.requireNonNull(steps);
    }

    public static Loop mainLoop(LoopCondition loopCondition, IdleStrategy idleStrategy, ExceptionHandler exceptionHandler, StepProvider ... stepProviders) {
        return new Loop(loopCondition, idleStrategy, exceptionHandler, Loop.toSteps(stepProviders, StepProvider::normalStep));
    }

    public static Loop shutdownLoop(LoopCondition loopCondition, IdleStrategy idleStrategy, ExceptionHandler exceptionHandler, StepProvider ... stepProviders) {
        return new Loop(loopCondition, idleStrategy, exceptionHandler, Loop.toSteps(stepProviders, StepProvider::shutdownStep));
    }

    public static StoppableThread start(IdleStrategy idleStrategy, ExceptionHandler exceptionHandler, ThreadFactory threadFactory, Step ... steps) {
        Objects.requireNonNull(idleStrategy);
        Objects.requireNonNull(exceptionHandler);
        Objects.requireNonNull(steps);
        return StoppableThread.start(running -> new Loop(workDone -> running.getAsBoolean(), idleStrategy, exceptionHandler, steps), threadFactory);
    }

    public static ShutdownableThread start(IdleStrategy idleStrategy, ExceptionHandler exceptionHandler, ThreadFactory threadFactory, StepProvider ... stepProviders) {
        Objects.requireNonNull(idleStrategy);
        Objects.requireNonNull(exceptionHandler);
        Objects.requireNonNull(stepProviders);
        return ShutdownableThread.start(runMain -> Loop.mainLoop(workDone -> runMain.getAsBoolean(), idleStrategy, exceptionHandler, stepProviders), runShutown -> Loop.shutdownLoop(workDone -> workDone && runShutown.getAsBoolean(), IdleStrategy.NO_OP, exceptionHandler, stepProviders), threadFactory);
    }

    @Override
    public void run() {
        boolean workDone;
        do {
            workDone = false;
            for (Step step : this.steps) {
                workDone |= this.exceptionHandler.performQuietly(this, step);
            }
            this.idleStrategy.idle(workDone);
        } while (this.loopCondition.loopAgain(workDone));
    }

    private static Step[] toSteps(StepProvider[] providers, Function<StepProvider, Step> providerInvoker) {
        int count = 0;
        for (StepProvider provider : providers) {
            if (providerInvoker.apply(provider) == Step.NO_OP) continue;
            ++count;
        }
        Step[] steps = new Step[count];
        int index = 0;
        for (StepProvider provider : providers) {
            Step step = providerInvoker.apply(provider);
            if (step == Step.NO_OP) continue;
            steps[index] = step;
            ++index;
        }
        assert (count == index);
        return steps;
    }
}

