/*
 * Decompiled with CFR 0.152.
 */
package org.tools4j.nobark.queue;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.tools4j.nobark.queue.AppenderListener;
import org.tools4j.nobark.queue.ConflationQueue;
import org.tools4j.nobark.queue.Entry;
import org.tools4j.nobark.queue.ExchangeConflationQueue;
import org.tools4j.nobark.queue.Factories;
import org.tools4j.nobark.queue.Merger;
import org.tools4j.nobark.queue.PollerListener;
import sun.misc.Contended;

public class MergeConflationQueue<K, V>
implements ExchangeConflationQueue<K, V> {
    private final Queue<Entry<K, MarkedValue<V>>> queue;
    private final Map<K, Entry<K, MarkedValue<V>>> entryMap;
    private final Merger<? super K, V> merger;
    private final ThreadLocal<ConflationQueue.Appender<K, V>> appender = ThreadLocal.withInitial(() -> new MergeQueueAppender());
    private final ThreadLocal<ExchangeConflationQueue.ExchangePoller<K, V>> poller = ThreadLocal.withInitial(() -> new MergeQueuePoller());
    private final Supplier<? extends AppenderListener<? super K, ? super V>> appenderListenerSupplier;
    private final Supplier<? extends PollerListener<? super K, ? super V>> pollerListenerSupplier;

    private MergeConflationQueue(Queue<Entry<K, MarkedValue<V>>> queue, Map<K, Entry<K, MarkedValue<V>>> entryMap, Merger<? super K, V> merger, Supplier<? extends AppenderListener<? super K, ? super V>> appenderListenerSupplier, Supplier<? extends PollerListener<? super K, ? super V>> pollerListenerSupplier) {
        this.queue = Objects.requireNonNull(queue);
        this.entryMap = Objects.requireNonNull(entryMap);
        this.merger = Objects.requireNonNull(merger);
        this.appenderListenerSupplier = Objects.requireNonNull(appenderListenerSupplier);
        this.pollerListenerSupplier = Objects.requireNonNull(pollerListenerSupplier);
    }

    public MergeConflationQueue(Supplier<? extends Queue<Object>> queueFactory, Merger<? super K, V> merger) {
        this(queueFactory, merger, () -> AppenderListener.NOOP, () -> PollerListener.NOOP);
    }

    public MergeConflationQueue(Supplier<? extends Queue<Object>> queueFactory, Merger<? super K, V> merger, Supplier<? extends AppenderListener<? super K, ? super V>> appenderListenerSupplier, Supplier<? extends PollerListener<? super K, ? super V>> pollerListenerSupplier) {
        this(queueFactory, ConcurrentHashMap::new, merger, appenderListenerSupplier, pollerListenerSupplier);
    }

    public MergeConflationQueue(Supplier<? extends Queue<Object>> queueFactory, Supplier<? extends Map<Object, Object>> entryMapFactory, Merger<? super K, V> merger, Supplier<? extends AppenderListener<? super K, ? super V>> appenderListenerSupplier, Supplier<? extends PollerListener<? super K, ? super V>> pollerListenerSupplier) {
        this(Factories.createQueue(queueFactory), Factories.createMap(entryMapFactory), merger, appenderListenerSupplier, pollerListenerSupplier);
    }

    public MergeConflationQueue(Supplier<? extends Queue<Object>> queueFactory, Merger<? super K, V> merger, List<? extends K> allConflationKeys) {
        this(queueFactory, merger, allConflationKeys, () -> AppenderListener.NOOP, () -> PollerListener.NOOP);
    }

    public MergeConflationQueue(Supplier<? extends Queue<Object>> queueFactory, Merger<? super K, V> merger, List<? extends K> allConflationKeys, Supplier<? extends AppenderListener<? super K, ? super V>> appenderListenerSupplier, Supplier<? extends PollerListener<? super K, ? super V>> pollerListenerSupplier) {
        this(Factories.createQueue(queueFactory), Entry.eagerlyInitialiseEntryMap(allConflationKeys, () -> new MarkedValue()), merger, appenderListenerSupplier, pollerListenerSupplier);
    }

    public static <K extends Enum<K>, V> MergeConflationQueue<K, V> forEnumConflationKey(Supplier<? extends Queue<Object>> queueFactory, Merger<? super K, V> merger, Class<K> conflationKeyClass) {
        return MergeConflationQueue.forEnumConflationKey(queueFactory, merger, conflationKeyClass, () -> AppenderListener.NOOP, () -> PollerListener.NOOP);
    }

    public static <K extends Enum<K>, V> MergeConflationQueue<K, V> forEnumConflationKey(Supplier<? extends Queue<Object>> queueFactory, Merger<? super K, V> merger, Class<K> conflationKeyClass, Supplier<? extends AppenderListener<? super K, ? super V>> appenderListenerSupplier, Supplier<? extends PollerListener<? super K, ? super V>> pollerListenerSupplier) {
        return new MergeConflationQueue<K, V>(Factories.createQueue(queueFactory), Entry.eagerlyInitialiseEntryEnumMap(conflationKeyClass, () -> new MarkedValue()), merger, appenderListenerSupplier, pollerListenerSupplier);
    }

    @Override
    public ConflationQueue.Appender<K, V> appender() {
        return this.appender.get();
    }

    @Override
    public ExchangeConflationQueue.ExchangePoller<K, V> poller() {
        return this.poller.get();
    }

    @Override
    public int size() {
        return this.queue.size();
    }

    private final class MergeQueuePoller
    implements ExchangeConflationQueue.ExchangePoller<K, V> {
        final PollerListener<? super K, ? super V> pollerListener;
        @Contended
        MarkedValue<V> markedValue;

        private MergeQueuePoller() {
            this.pollerListener = (PollerListener)MergeConflationQueue.this.pollerListenerSupplier.get();
            this.markedValue = new MarkedValue();
        }

        @Override
        public V poll(BiConsumer<? super K, ? super V> consumer, V exchange) {
            Entry entry = (Entry)MergeConflationQueue.this.queue.poll();
            if (entry != null) {
                MarkedValue exchangeValue = this.markedValue.initalizeWithUnused(exchange);
                MarkedValue polledValue = entry.value.getAndSet(exchangeValue);
                Object value = polledValue.markUnusedAndRelease();
                this.markedValue = polledValue;
                consumer.accept(entry.key, value);
                this.pollerListener.polled(MergeConflationQueue.this, entry.key, value);
                return value;
            }
            this.pollerListener.polledButFoundEmpty(MergeConflationQueue.this);
            return null;
        }
    }

    private final class MergeQueueAppender
    implements ConflationQueue.Appender<K, V> {
        final AppenderListener<? super K, ? super V> appenderListener;
        @Contended
        MarkedValue<V> markedValue;

        private MergeQueueAppender() {
            this.appenderListener = (AppenderListener)MergeConflationQueue.this.appenderListenerSupplier.get();
            this.markedValue = new MarkedValue();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V enqueue(K conflationKey, V value) {
            Object old;
            AppenderListener.Conflation conflation;
            Object add;
            block6: {
                Objects.requireNonNull(value);
                Entry entry = MergeConflationQueue.this.entryMap.computeIfAbsent(conflationKey, k -> new Entry(k, new MarkedValue()));
                MarkedValue newValue = this.markedValue.initializeWithUnconfirmed(value);
                MarkedValue oldValue = entry.value.getAndSet(newValue);
                try {
                    if (oldValue.isUnused()) {
                        newValue.confirm();
                        MergeConflationQueue.this.queue.add(entry);
                        add = value;
                        conflation = AppenderListener.Conflation.UNCONFLATED;
                        break block6;
                    }
                    Object previous = oldValue.value;
                    try {
                        add = MergeConflationQueue.this.merger.merge(conflationKey, previous, value);
                        newValue.confirmWith(add);
                        conflation = AppenderListener.Conflation.MERGED;
                    }
                    catch (Throwable t) {
                        newValue.confirmWith(previous);
                        throw t;
                    }
                }
                finally {
                    this.markedValue = oldValue;
                    old = oldValue.markUnusedAndRelease();
                }
            }
            this.appenderListener.enqueued(MergeConflationQueue.this, conflationKey, add, old, conflation);
            return old;
        }
    }

    @Contended
    private static final class MarkedValue<V> {
        V value;
        volatile State state = State.UNUSED;

        private MarkedValue() {
        }

        MarkedValue<V> initializeWithUnconfirmed(V value) {
            this.value = Objects.requireNonNull(value);
            this.state = State.UNCONFIRMED;
            return this;
        }

        MarkedValue<V> initalizeWithUnused(V value) {
            this.value = value;
            this.state = State.UNUSED;
            return this;
        }

        void confirm() {
            this.state = State.CONFIRMED;
        }

        void confirmWith(V value) {
            this.value = value;
            this.state = State.CONFIRMED;
        }

        V markUnusedAndRelease() {
            this.awaitFinalState();
            V released = this.value;
            this.state = State.UNUSED;
            this.value = null;
            return released;
        }

        boolean isUnused() {
            return this.awaitFinalState() == State.UNUSED;
        }

        private State awaitFinalState() {
            State s;
            while ((s = this.state) == State.UNCONFIRMED) {
            }
            return s;
        }

        static enum State {
            UNCONFIRMED,
            CONFIRMED,
            UNUSED;

        }
    }
}

