/*
 * Decompiled with CFR 0.152.
 */
package org.tools4j.elara.plugin.timer;

import java.util.Objects;
import java.util.function.Consumer;
import org.tools4j.elara.init.Context;
import org.tools4j.elara.plugin.api.Plugins;
import org.tools4j.elara.plugin.timer.TimerControl;
import org.tools4j.elara.plugin.timer.TimerEvents;
import org.tools4j.elara.plugin.timer.TimerState;
import org.tools4j.elara.route.EventRouter;

public class DefaultTimerControl
implements TimerControl,
Consumer<TimerState> {
    private TimerState timerState;

    public DefaultTimerControl() {
    }

    public DefaultTimerControl(Context context) {
        context.plugin(Plugins.timerPlugin(), this);
    }

    public DefaultTimerControl(TimerState timerState) {
        this.timerState = Objects.requireNonNull(timerState);
    }

    @Override
    public void accept(TimerState timerState) {
        this.timerState = Objects.requireNonNull(timerState);
    }

    public TimerState timerState() {
        if (this.timerState == null) {
            throw new IllegalStateException("timer state is not initialised");
        }
        return this.timerState;
    }

    @Override
    public boolean startTimer(long id, int type, long timeout, EventRouter eventRouter) {
        if (this.timerState().hasTimer(id)) {
            return false;
        }
        TimerEvents.routeTimerStarted(id, type, timeout, eventRouter);
        return true;
    }

    @Override
    public boolean startPeriodic(long id, int type, long timeout, EventRouter eventRouter) {
        if (this.timerState().hasTimer(id)) {
            return false;
        }
        TimerEvents.routePeriodicStarted(id, type, timeout, eventRouter);
        return true;
    }

    @Override
    public boolean stopTimer(long id, EventRouter eventRouter) {
        TimerState timerState = this.timerState();
        int index = timerState.indexById(id);
        if (index < 0) {
            return false;
        }
        TimerEvents.routeTimerStopped(id, timerState.type(index), timerState.repetition(index), timerState.timeout(index), eventRouter);
        return true;
    }
}

