/*
 * Decompiled with CFR 0.152.
 */
package org.tools4j.elara.plugin.timer;

import java.util.ArrayList;
import java.util.List;
import org.agrona.collections.Long2LongHashMap;
import org.tools4j.elara.plugin.timer.TimerState;

public class DeadlineHeapTimerState
implements TimerState.Mutable {
    public static final int DEFAULT_INITIAL_CAPACITY = 64;
    private final Long2LongHashMap idToIndex;
    private final List<Timer> timerHeapByDeadline;
    private final List<Timer> unused;

    public DeadlineHeapTimerState() {
        this(64);
    }

    public DeadlineHeapTimerState(int initialCapacity) {
        this.idToIndex = new Long2LongHashMap(2 * initialCapacity, 0.55f, -1L);
        this.timerHeapByDeadline = new ArrayList<Timer>(initialCapacity);
        this.unused = new ArrayList<Timer>(initialCapacity);
        for (int i = 0; i < initialCapacity; ++i) {
            this.unused.add(new Timer());
        }
    }

    @Override
    public int count() {
        return this.timerHeapByDeadline.size();
    }

    @Override
    public int indexById(long id) {
        return (int)this.idToIndex.get(id);
    }

    @Override
    public long id(int index) {
        return this.timerHeapByDeadline.get((int)index).id;
    }

    @Override
    public int type(int index) {
        return this.timerHeapByDeadline.get((int)index).type;
    }

    @Override
    public int repetition(int index) {
        return this.timerHeapByDeadline.get((int)index).repetition;
    }

    @Override
    public long time(int index) {
        return this.timerHeapByDeadline.get((int)index).time;
    }

    @Override
    public long timeout(int index) {
        return this.timerHeapByDeadline.get((int)index).timeout;
    }

    @Override
    public long deadline(int index) {
        return this.timerHeapByDeadline.get(index).deadline();
    }

    @Override
    public int nextRepetition(int index) {
        return this.timerHeapByDeadline.get(index).nextRepetition();
    }

    @Override
    public boolean hasTimer(long id) {
        return this.idToIndex.containsKey(id);
    }

    @Override
    public int indexOfNextDeadline() {
        return this.timerHeapByDeadline.isEmpty() ? -1 : 0;
    }

    @Override
    public boolean add(long id, int type, int repetition, long time, long timeout) {
        if (!this.hasTimer(id)) {
            this.add(this.acquire().init(id, type, repetition, time, timeout));
            return true;
        }
        return false;
    }

    private void add(Timer timer) {
        int index = this.timerHeapByDeadline.size();
        if (index == 0) {
            this.timerHeapByDeadline.add(timer);
            this.idToIndex.put(timer.id, (long)index);
        } else {
            this.timerHeapByDeadline.add(null);
            this.siftUp(index, timer);
        }
    }

    private void siftUp(int index, Timer timer) {
        int parent;
        Timer p;
        long deadline = timer.deadline();
        int k = index;
        while (k > 0 && deadline < (p = this.timerHeapByDeadline.get(parent = k - 1 >>> 1)).deadline()) {
            this.set(k, p);
            k = parent;
        }
        this.set(k, timer);
    }

    private void siftDown(int index, Timer timer) {
        long deadline = timer.deadline();
        int size = this.timerHeapByDeadline.size();
        int k = index;
        int half = size >>> 1;
        while (k < half) {
            int child = (k << 1) + 1;
            int right = child + 1;
            Timer c = this.timerHeapByDeadline.get(child);
            if (right < size) {
                Timer r = this.timerHeapByDeadline.get(right);
                if (c.deadline() > r.deadline()) {
                    child = right;
                    c = r;
                }
            }
            if (deadline <= c.deadline()) break;
            this.set(k, c);
            k = child;
        }
        this.set(k, timer);
    }

    private Timer set(int index, Timer timer) {
        this.idToIndex.put(timer.id, (long)index);
        return this.timerHeapByDeadline.set(index, timer);
    }

    @Override
    public void remove(int index) {
        Timer timer = this.timerHeapByDeadline.set(index, null);
        this.idToIndex.remove(timer.id);
        int s = this.timerHeapByDeadline.size() - 1;
        Timer moved = this.timerHeapByDeadline.remove(s);
        if (s != index) {
            this.siftDown(index, moved);
        }
        this.release(timer);
    }

    @Override
    public void repetition(int index, int repetition) {
        Timer timer = this.timerHeapByDeadline.get(index);
        int prevRepetition = timer.repetition;
        if (timer.repetition == repetition) {
            return;
        }
        timer.repetition = repetition;
        if (repetition > prevRepetition) {
            this.siftDown(index, timer);
        } else {
            this.siftUp(index, timer);
        }
    }

    private Timer acquire() {
        int last = this.unused.size() - 1;
        return last >= 0 ? this.unused.remove(last) : new Timer();
    }

    private void release(Timer timer) {
        this.unused.add(timer.reset());
    }

    public String toString() {
        if (this.count() == 0) {
            return "DeadlineHeapTimerState{}";
        }
        return "DeadlineHeapTimerState{next=" + this.id(this.indexOfNextDeadline()) + ", ids=" + this.idToIndex.keySet() + "}";
    }

    private static final class Timer {
        long id;
        int type;
        int repetition;
        long time;
        long timeout;

        private Timer() {
        }

        final int nextRepetition() {
            return TimerState.Static.nextRepetition(this.repetition);
        }

        final long deadline() {
            return TimerState.Static.deadline(this.time, this.timeout, this.nextRepetition());
        }

        final Timer init(long id, int type, int repetition, long time, long timeout) {
            this.id = id;
            this.type = type;
            this.repetition = repetition;
            this.time = time;
            this.timeout = timeout;
            return this;
        }

        final Timer reset() {
            return this.init(0L, 0, 0, 0L, 0L);
        }
    }
}

