/*
 * Decompiled with CFR 0.152.
 */
package org.tools4j.elara.plugin.replication;

import java.util.Objects;
import org.tools4j.elara.application.CommandProcessor;
import org.tools4j.elara.application.EventApplier;
import org.tools4j.elara.init.ExecutionType;
import org.tools4j.elara.log.MessageLog;
import org.tools4j.elara.plugin.api.Plugin;
import org.tools4j.elara.plugin.api.Plugins;
import org.tools4j.elara.plugin.api.SystemPlugin;
import org.tools4j.elara.plugin.api.TypeRange;
import org.tools4j.elara.plugin.base.BaseState;
import org.tools4j.elara.plugin.replication.Configuration;
import org.tools4j.elara.plugin.replication.ConnectionHandler;
import org.tools4j.elara.plugin.replication.Context;
import org.tools4j.elara.plugin.replication.DefaultEventSender;
import org.tools4j.elara.plugin.replication.DefaultReplicationState;
import org.tools4j.elara.plugin.replication.DispatchingPublisher;
import org.tools4j.elara.plugin.replication.EnforcedLeaderEventReceiver;
import org.tools4j.elara.plugin.replication.ReplicationCommandProcessor;
import org.tools4j.elara.plugin.replication.ReplicationEventApplier;
import org.tools4j.elara.plugin.replication.ReplicationPluginStep;
import org.tools4j.elara.plugin.replication.ReplicationState;
import org.tools4j.nobark.loop.Step;

public class ReplicationPlugin
implements SystemPlugin<ReplicationState.Mutable> {
    private static final Plugin.Dependency<?>[] DEPENDENCIES = new Plugin.Dependency[]{Plugin.Dependency.of(Plugins.basePlugin(), baseState -> baseState.processCommands(false)), Plugin.Dependency.of(Plugins.bootPlugin())};
    private final Configuration configuration;

    public ReplicationPlugin(Configuration configuration) {
        this.configuration = Configuration.validate(configuration);
    }

    public static Context configure() {
        return Context.create();
    }

    @Override
    public TypeRange typeRange() {
        return TypeRange.REPLICATION;
    }

    @Override
    public ReplicationState.Mutable defaultPluginState() {
        return new DefaultReplicationState();
    }

    @Override
    public Plugin.Dependency<?>[] dependencies() {
        return DEPENDENCIES;
    }

    @Override
    public Plugin.Configuration configuration(final org.tools4j.elara.init.Configuration appConfig, final ReplicationState.Mutable replicationState) {
        Objects.requireNonNull(appConfig);
        Objects.requireNonNull(replicationState);
        MessageLog eventLog = appConfig.eventLog();
        final MessageLog.Appender eventLogAppender = eventLog.appender();
        final EnforcedLeaderEventReceiver enforcedLeaderEventReceiver = new EnforcedLeaderEventReceiver(appConfig.loggerFactory(), appConfig.timeSource(), this.configuration, replicationState, eventLogAppender);
        final DispatchingPublisher dispatchingPublisher = new DispatchingPublisher(this.configuration);
        final DefaultEventSender eventSender = new DefaultEventSender(this.configuration, replicationState, eventLog, dispatchingPublisher);
        return new Plugin.Configuration.Default(){

            @Override
            public Step step(BaseState baseState, ExecutionType executionType) {
                switch (executionType) {
                    case ALWAYS_WHEN_EVENTS_APPLIED: {
                        ConnectionHandler connectionHandler = new ConnectionHandler(appConfig.loggerFactory(), ReplicationPlugin.this.configuration, baseState, replicationState, eventLogAppender, dispatchingPublisher);
                        return new ReplicationPluginStep(ReplicationPlugin.this.configuration, replicationState, enforcedLeaderEventReceiver, connectionHandler, eventSender);
                    }
                }
                return Step.NO_OP;
            }

            @Override
            public CommandProcessor commandProcessor(BaseState baseState) {
                return new ReplicationCommandProcessor(appConfig.loggerFactory(), ReplicationPlugin.this.configuration, replicationState);
            }

            @Override
            public EventApplier eventApplier(BaseState.Mutable baseState) {
                return new ReplicationEventApplier(appConfig.loggerFactory(), ReplicationPlugin.this.configuration, baseState, replicationState);
            }
        };
    }
}

