/*
 * Decompiled with CFR 0.152.
 */
package org.tools4j.elara.plugin.replication;

import java.util.Objects;
import org.tools4j.elara.application.CommandProcessor;
import org.tools4j.elara.command.Command;
import org.tools4j.elara.logging.ElaraLogger;
import org.tools4j.elara.logging.Logger;
import org.tools4j.elara.plugin.replication.Configuration;
import org.tools4j.elara.plugin.replication.ReplicationCommands;
import org.tools4j.elara.plugin.replication.ReplicationEvents;
import org.tools4j.elara.plugin.replication.ReplicationState;
import org.tools4j.elara.route.EventRouter;

public class ReplicationCommandProcessor
implements CommandProcessor {
    private final ElaraLogger logger;
    private final Configuration configuration;
    private final ReplicationState replicationState;

    public ReplicationCommandProcessor(Logger.Factory loggerFactory, Configuration configuration, ReplicationState replicationState) {
        this.logger = ElaraLogger.create(loggerFactory, this.getClass());
        this.configuration = Objects.requireNonNull(configuration);
        this.replicationState = Objects.requireNonNull(replicationState);
    }

    @Override
    public void onCommand(Command command, EventRouter router) {
        if (command.type() == -20) {
            if (this.isLeader()) {
                try (EventRouter.RoutingContext context = router.routingEvent(-90);){
                    int length = ReplicationEvents.leaderElected(context.buffer(), 0, this.replicationState.currentTerm() + 1, -1);
                    context.route(length);
                }
            }
        } else if (command.type() == -90) {
            int leaderId;
            String commandName = ReplicationCommands.replicationCommandName(command);
            int serverId = this.configuration.serverId();
            int candidateId = ReplicationCommands.candidateId(command);
            if (candidateId != (leaderId = this.replicationState.leaderId())) {
                int nextTerm = this.replicationState.currentTerm() + 1;
                this.logger.info("Server {} processing {}: electing candidate {} to replace current leader {} for next term {}").replace(serverId).replace(commandName).replace(candidateId).replace(leaderId).replace(nextTerm).format();
                try (EventRouter.RoutingContext context = router.routingEvent(-90);){
                    int length = ReplicationEvents.leaderElected(context.buffer(), 0, nextTerm, candidateId);
                    context.route(length);
                }
            } else {
                this.logger.info("Server {} processing {}: ignored since proposed candidate {} is already leader").replace(serverId).replace(commandName).replace(candidateId).format();
            }
        }
    }

    private boolean isLeader() {
        return this.configuration.serverId() == this.replicationState.leaderId();
    }
}

