/*
 * Decompiled with CFR 0.152.
 */
package org.tools4j.elara.plugin.metrics;

import java.util.Objects;
import java.util.Set;

public enum TimeMetric {
    INPUT_SENDING_TIME,
    INPUT_POLLING_TIME,
    COMMAND_APPENDING_TIME,
    COMMAND_POLLING_TIME,
    PROCESSING_START_TIME,
    ROUTING_START_TIME,
    ROUTING_END_TIME,
    EVENT_POLLING_TIME,
    OUTPUT_POLLING_TIME,
    APPLYING_START_TIME,
    APPLYING_END_TIME,
    PROCESSING_END_TIME,
    OUTPUT_START_TIME,
    OUTPUT_END_TIME,
    METRIC_APPENDING_TIME;

    private static final TimeMetric[] VALUES;

    public static int count() {
        return VALUES.length;
    }

    public static TimeMetric byOrdinal(int ordinal) {
        return VALUES[ordinal];
    }

    static /* synthetic */ TimeMetric[] access$000() {
        return VALUES;
    }

    static {
        VALUES = TimeMetric.values();
    }

    public static enum Target {
        COMMAND(INPUT_SENDING_TIME, INPUT_POLLING_TIME, COMMAND_APPENDING_TIME, COMMAND_POLLING_TIME, PROCESSING_START_TIME, PROCESSING_END_TIME, METRIC_APPENDING_TIME),
        EVENT(ROUTING_START_TIME, ROUTING_END_TIME, EVENT_POLLING_TIME, APPLYING_START_TIME, APPLYING_END_TIME, METRIC_APPENDING_TIME),
        OUTPUT(OUTPUT_POLLING_TIME, OUTPUT_START_TIME, OUTPUT_END_TIME, METRIC_APPENDING_TIME);

        private static final byte OUTPUT_BIT = 64;
        private static final int[] BIT_COUNT;
        private final byte allFlags;
        private final TimeMetric[] metrics;
        private final byte[] metricFlagByOrdinal = new byte[TimeMetric.access$000().length];

        private Target(TimeMetric ... metrics) {
            this.metrics = Objects.requireNonNull(metrics);
            byte all = 0;
            for (int i = 0; i < metrics.length; ++i) {
                byte flag = (byte)(1 << i);
                all = (byte)(all | flag);
                this.metricFlagByOrdinal[metrics[i].ordinal()] = flag;
            }
            this.allFlags = all;
        }

        public byte flag(TimeMetric metric) {
            return this.metricFlagByOrdinal[metric.ordinal()];
        }

        public byte flags(Set<TimeMetric> metrics) {
            byte flags = this == OUTPUT ? (byte)64 : 0;
            for (TimeMetric metric : metrics) {
                if (!metrics.contains((Object)metric)) continue;
                flags = (byte)(flags | this.flag(metric));
            }
            return flags;
        }

        public boolean isMetric(TimeMetric metric) {
            return this.flag(metric) != 0;
        }

        public boolean anyOf(Set<TimeMetric> metrics) {
            for (TimeMetric metric : metrics) {
                if (!metrics.contains((Object)metric)) continue;
                return true;
            }
            return false;
        }

        public int count(byte flags) {
            int f = this.allFlags & flags;
            return BIT_COUNT[0xF & f] + BIT_COUNT[0xF & f >>> 4];
        }

        public TimeMetric metric(byte flags, int index) {
            int f = this.allFlags & flags;
            int count = 0;
            for (int i = 0; i < this.metrics.length && f != 0; f >>>= 1, ++i) {
                if ((f & 1) == 0) continue;
                if (count == index) {
                    return this.metrics[i];
                }
                ++count;
            }
            return null;
        }

        public static Target target(byte flags, int index) {
            if (index >= 0) {
                return (0x40 & flags) != 0 ? OUTPUT : EVENT;
            }
            return COMMAND;
        }

        static {
            BIT_COUNT = new int[]{0, 1, 1, 2, 1, 2, 2, 3, 1, 2, 2, 3, 2, 3, 3, 4};
        }
    }
}

