/*
 * Decompiled with CFR 0.152.
 */
package org.tools4j.elara.plugin.metrics;

import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.tools4j.elara.flyweight.Flyweight;
import org.tools4j.elara.plugin.metrics.FrequencyMetric;
import org.tools4j.elara.plugin.metrics.MetricsDescriptor;
import org.tools4j.elara.plugin.metrics.MetricsLogEntry;
import org.tools4j.elara.plugin.metrics.TimeMetric;

public class FlyweightMetricsLogEntry
implements MetricsLogEntry,
Flyweight<FlyweightMetricsLogEntry> {
    private final MutableDirectBuffer buffer = new UnsafeBuffer(0L, 0);

    @Override
    public FlyweightMetricsLogEntry init(DirectBuffer src, int srcOffset) {
        int length = src.capacity() - srcOffset;
        if (length < 24) {
            throw new IllegalArgumentException("Invalid metrics log entry, expected min length + 24 but found only " + length);
        }
        FlyweightMetricsLogEntry.validateVersion(src.getByte(srcOffset + 0));
        this.buffer.wrap(src, srcOffset + 0, 24);
        int count = this.count();
        this.buffer.wrap(src, srcOffset + 0, 24 + count * 8);
        return this;
    }

    public boolean valid() {
        return this.buffer.capacity() >= 24;
    }

    public FlyweightMetricsLogEntry reset() {
        this.buffer.wrap(0L, 0);
        return this;
    }

    @Override
    public short version() {
        return MetricsDescriptor.version((DirectBuffer)this.buffer);
    }

    @Override
    public byte flags() {
        return MetricsDescriptor.flags((DirectBuffer)this.buffer);
    }

    @Override
    public short index() {
        return MetricsDescriptor.index((DirectBuffer)this.buffer);
    }

    @Override
    public int source() {
        return MetricsDescriptor.source((DirectBuffer)this.buffer);
    }

    @Override
    public long sequence() {
        return MetricsDescriptor.sequence((DirectBuffer)this.buffer);
    }

    @Override
    public long time() {
        return MetricsDescriptor.time((DirectBuffer)this.buffer);
    }

    @Override
    public short choice() {
        return MetricsDescriptor.choice((DirectBuffer)this.buffer);
    }

    @Override
    public int repetition() {
        return MetricsDescriptor.repetition((DirectBuffer)this.buffer);
    }

    @Override
    public long interval() {
        return MetricsDescriptor.interval((DirectBuffer)this.buffer);
    }

    @Override
    public MetricsLogEntry.Type type() {
        return MetricsDescriptor.isTimeMetrics((DirectBuffer)this.buffer) ? MetricsLogEntry.Type.TIME : MetricsLogEntry.Type.FREQUENCY;
    }

    @Override
    public TimeMetric.Target target() {
        return TimeMetric.Target.target(this.flags(), this.index());
    }

    @Override
    public int count() {
        return MetricsDescriptor.isTimeMetrics((DirectBuffer)this.buffer) ? this.target().count(this.flags()) : FrequencyMetric.count(this.choice());
    }

    @Override
    public long time(int index) {
        return MetricsDescriptor.time(index, (DirectBuffer)this.buffer);
    }

    @Override
    public long counter(int index) {
        return MetricsDescriptor.counter(index, (DirectBuffer)this.buffer);
    }

    public static int writeTimeMetricsHeader(byte flags, short index, int source, long sequence, long time, MutableDirectBuffer dst, int dstOffset) {
        dst.putByte(dstOffset + 0, (byte)2);
        dst.putByte(dstOffset + 1, flags);
        dst.putShort(dstOffset + 2, index);
        dst.putInt(dstOffset + 4, source);
        dst.putLong(dstOffset + 8, sequence);
        dst.putLong(dstOffset + 16, time);
        return 24;
    }

    public static int writeTime(long time, MutableDirectBuffer dst, int dstOffset) {
        dst.putLong(dstOffset, time);
        return 8;
    }

    public static int writeFrequencyMetricsHeader(short choice, int repetition, long interval, long time, MutableDirectBuffer dst, int dstOffset) {
        dst.putByte(dstOffset + 0, (byte)2);
        dst.putByte(dstOffset + 1, (byte)0);
        dst.putShort(dstOffset + 2, choice);
        dst.putInt(dstOffset + 4, repetition);
        dst.putLong(dstOffset + 8, interval);
        dst.putLong(dstOffset + 16, time);
        return 24;
    }

    public static int writeCounter(long counter, MutableDirectBuffer dst, int dstOffset) {
        dst.putLong(dstOffset, counter);
        return 8;
    }

    public static void validateVersion(short version) {
        if (version != 2) {
            throw new IllegalArgumentException("Metric version " + version + " is not compatible with current version " + 2);
        }
    }

    public String toString() {
        if (!this.valid()) {
            return "FlyweightMetricsLogEntry";
        }
        return this.type() == MetricsLogEntry.Type.TIME ? "FlyweightMetricsLogEntry{version=" + this.version() + ", type=" + (Object)((Object)this.type()) + ", flags=" + Integer.toBinaryString(this.flags()) + ", index=" + this.index() + ", source=" + this.source() + ", sequence=" + this.sequence() + ", time=" + this.time() + ", count=" + this.count() + '}' : "FlyweightMetricsLogEntry{version=" + this.version() + ", type=" + (Object)((Object)this.type()) + ", choice=" + Integer.toBinaryString(this.choice()) + ", repetition=" + this.repetition() + ", interval=" + this.interval() + ", time=" + this.time() + ", count=" + this.count() + '}';
    }
}

