/*
 * Decompiled with CFR 0.152.
 */
package org.tools4j.elara.plugin.boot;

import java.util.Objects;
import org.tools4j.elara.application.CommandProcessor;
import org.tools4j.elara.init.Configuration;
import org.tools4j.elara.init.ExecutionType;
import org.tools4j.elara.input.DefaultReceiver;
import org.tools4j.elara.input.SequenceGenerator;
import org.tools4j.elara.input.SimpleSequenceGenerator;
import org.tools4j.elara.output.Output;
import org.tools4j.elara.plugin.api.Plugin;
import org.tools4j.elara.plugin.api.SystemPlugin;
import org.tools4j.elara.plugin.api.TypeRange;
import org.tools4j.elara.plugin.base.BaseState;
import org.tools4j.elara.plugin.boot.BootCommandProcessor;
import org.tools4j.elara.plugin.boot.BootOutput;
import org.tools4j.nobark.loop.Step;

public class BootPlugin
implements SystemPlugin<Plugin.NullState> {
    public static final int DEFAULT_COMMAND_SOURCE = -20;
    public static final BootPlugin DEFAULT = new BootPlugin(-20, new SimpleSequenceGenerator(System.currentTimeMillis()));
    private final int commandSource;
    private final SequenceGenerator sequenceGenerator;

    public BootPlugin(int commandSource, SequenceGenerator sequenceGenerator) {
        this.commandSource = commandSource;
        this.sequenceGenerator = Objects.requireNonNull(sequenceGenerator);
    }

    @Override
    public TypeRange typeRange() {
        return TypeRange.BOOT;
    }

    @Override
    public Plugin.NullState defaultPluginState() {
        return Plugin.NullState.NULL;
    }

    @Override
    public Plugin.Configuration configuration(final Configuration appConfig, Plugin.NullState pluginState) {
        Objects.requireNonNull(appConfig);
        Objects.requireNonNull(pluginState);
        return new Plugin.Configuration.Default(){

            @Override
            public Step step(BaseState baseState, ExecutionType executionType) {
                if (executionType == ExecutionType.INIT_ONCE_ONLY) {
                    return () -> {
                        BootPlugin.this.appendAppInitStartCommand(appConfig);
                        return true;
                    };
                }
                return Step.NO_OP;
            }

            @Override
            public Output output(BaseState baseState) {
                return new BootOutput();
            }

            @Override
            public CommandProcessor commandProcessor(BaseState baseState) {
                return new BootCommandProcessor();
            }
        };
    }

    private void appendAppInitStartCommand(Configuration appConfig) {
        DefaultReceiver receiver = new DefaultReceiver(appConfig.timeSource(), appConfig.commandLog().appender());
        receiver.receiveMessageWithoutPayload(this.commandSource, this.sequenceGenerator.nextSequence(), -20);
    }
}

