/*
 * Decompiled with CFR 0.152.
 */
package org.tools4j.elara.loop;

import java.util.Objects;
import org.agrona.DirectBuffer;
import org.tools4j.elara.flyweight.FlyweightEvent;
import org.tools4j.elara.handler.OutputHandler;
import org.tools4j.elara.log.CommittedEventPoller;
import org.tools4j.elara.log.MessageLog;
import org.tools4j.elara.output.Output;
import org.tools4j.nobark.loop.Step;

public class OutputStep
implements Step {
    public static final String DEFAULT_POLLER_ID = "elara-out";
    private final OutputHandler handler;
    private final MessageLog.Poller poller;
    private final MessageLog.Handler replayHandler = buffer -> this.onMessage(buffer, true);
    private final MessageLog.Handler defaultHandler = buffer -> this.onMessage(buffer, false);
    private final FlyweightEvent flyweightEvent = new FlyweightEvent();
    private MessageLog.Poller replayPoller;
    private int retry;

    public OutputStep(OutputHandler handler, MessageLog messageLog) {
        this(handler, new CommittedEventPoller(messageLog), null);
    }

    public OutputStep(OutputHandler handler, MessageLog messageLog, String id) {
        this(handler, new CommittedEventPoller(messageLog, id), messageLog.poller());
    }

    private OutputStep(OutputHandler handler, MessageLog.Poller poller, MessageLog.Poller replayPoller) {
        this.handler = Objects.requireNonNull(handler);
        this.poller = Objects.requireNonNull(poller);
        this.replayPoller = replayPoller;
    }

    public boolean perform() {
        if (this.replayPoller != null) {
            if (this.replayPoller.entryId() < this.poller.entryId()) {
                return this.replayPoller.poll(this.replayHandler) > 0;
            }
            this.replayPoller = null;
        }
        return this.poller.poll(this.defaultHandler) > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MessageLog.Handler.Result onMessage(DirectBuffer message, boolean replay) {
        this.flyweightEvent.init(message, 0);
        try {
            Output.Ack ack = this.handler.publish(this.flyweightEvent, replay, this.retry);
            if (Output.Ack.RETRY != ack) {
                this.retry = 0;
                MessageLog.Handler.Result result = MessageLog.Handler.Result.POLL;
                return result;
            }
            ++this.retry;
            MessageLog.Handler.Result result = MessageLog.Handler.Result.PEEK;
            return result;
        }
        finally {
            this.flyweightEvent.reset();
        }
    }
}

