/*
 * Decompiled with CFR 0.152.
 */
package org.tools4j.elara.logging;

import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.tools4j.elara.logging.ElaraLogger;
import org.tools4j.elara.logging.FlyweightPlaceholderReplacer;
import org.tools4j.elara.logging.Logger;
import org.tools4j.elara.logging.PlaceholderReplacer;

public class DefaultElaraLogger
implements ElaraLogger {
    private static final int DEFAULT_INITIAL_MESSAGE_CAPACITY = 128;
    private static final Logger.Level[] LEVELS = Logger.Level.values();
    private final Logger logger;
    private final Map<Logger.Level, Consumer<CharSequence>> levelLogger;
    private final Supplier<? extends FlyweightPlaceholderReplacer> placeholderReplacerSupplier;

    public DefaultElaraLogger(Logger logger, Supplier<? extends FlyweightPlaceholderReplacer> placeholderReplacerSupplier) {
        this.logger = Objects.requireNonNull(logger);
        this.placeholderReplacerSupplier = Objects.requireNonNull(placeholderReplacerSupplier);
        this.levelLogger = new EnumMap<Logger.Level, Consumer<CharSequence>>(Logger.Level.class);
        for (Logger.Level level : LEVELS) {
            this.levelLogger.put(level, s -> logger.log(level, (CharSequence)s));
        }
    }

    public static DefaultElaraLogger create(Logger logger) {
        return new DefaultElaraLogger(logger, () -> new FlyweightPlaceholderReplacer(128));
    }

    public static DefaultElaraLogger threadLocal(Logger logger) {
        return new DefaultElaraLogger(logger, ThreadLocal.withInitial(() -> new FlyweightPlaceholderReplacer(128))::get);
    }

    @Override
    public PlaceholderReplacer log(Logger.Level level, String message) {
        return this.placeholderReplacerSupplier.get().init(this.levelLogger.get((Object)level), message);
    }

    @Override
    public boolean isEnabled(Logger.Level level) {
        return this.logger.isEnabled(level);
    }
}

