/*
 * Decompiled with CFR 0.152.
 */
package org.tools4j.elara.log;

import java.util.Objects;
import org.agrona.DirectBuffer;
import org.agrona.ExpandableArrayBuffer;
import org.agrona.MutableDirectBuffer;
import org.tools4j.elara.flyweight.FlyweightEvent;
import org.tools4j.elara.log.MessageLog;
import org.tools4j.elara.plugin.base.BaseEvents;

public class EventLogRepairer {
    private static final int MAX_EVENT_INDEX = Short.MAX_VALUE;
    private final MessageLog eventLog;
    private final FlyweightEvent lastNonFinalEventOrNull;

    public EventLogRepairer(MessageLog eventLog) {
        this.eventLog = Objects.requireNonNull(eventLog);
        this.lastNonFinalEventOrNull = EventLogRepairer.lastNonFinalEventOrNull(eventLog);
    }

    public boolean isCorrupted() {
        return null != this.lastNonFinalEventOrNull;
    }

    public boolean repair() {
        if (this.lastNonFinalEventOrNull != null) {
            FlyweightEvent event = this.lastNonFinalEventOrNull;
            int nextIndex = this.lastNonFinalEventOrNull.index() + 1;
            if (nextIndex > Short.MAX_VALUE) {
                throw new RuntimeException("Event index " + nextIndex + " exceeds max allowed " + Short.MAX_VALUE);
            }
            try (MessageLog.AppendingContext context = this.eventLog.appender().appending();){
                BaseEvents.rollback(event, context.buffer(), 0, event.source(), event.sequence(), (short)nextIndex, event.time());
                context.commit(32);
            }
            return true;
        }
        return false;
    }

    private static FlyweightEvent lastNonFinalEventOrNull(MessageLog eventLog) {
        MessageLog.Poller poller = eventLog.poller();
        poller.moveToEnd();
        if (poller.moveToPrevious()) {
            FlyweightEvent event = new FlyweightEvent();
            if (0 == poller.poll(message -> {
                int length = message.capacity();
                ExpandableArrayBuffer copy = new ExpandableArrayBuffer(length);
                message.getBytes(0, (MutableDirectBuffer)copy, 0, length);
                event.init((DirectBuffer)copy, 0);
                return MessageLog.Handler.Result.POLL;
            })) {
                throw new RuntimeException("Poller should have returned last event");
            }
            if (event.index() < 0) {
                throw new IllegalArgumentException("Not an event log (is it a command log?): " + eventLog);
            }
            if (event.flags().isFinal()) {
                return null;
            }
            if (event.index() >= Short.MAX_VALUE) {
                throw new IllegalArgumentException("Event log cannot be repaired, last event has maximum allowed index: " + event.index());
            }
            return event;
        }
        return null;
    }
}

